#lang racket

#|
"02_disentanglement.rkt"

This file is a modification of "01_runs.rkt":
+ disentanglement
|#

(require "../common/common.rkt")
(require "../common/term.rkt")
(require "../common/closure.rkt")

(struct ap () #:transparent)

(define (run-t t s e c d)
  (match t
  [(*var x)   (run-c (cons (second (assoc x e)) s) e c d)]
  [(*lam x t) (run-c (cons (*closure (*lam x t) e) s) e c d)]
  [(*app l r) (run-c s e (list* r l (ap) c) d)]))

(define (run-c s e c d)
  (match c
  ['()           (run-d d (car s))]
  [(cons (ap) c) (match s
                 [(list* (*closure (*lam x t) e1) t2 s)
                   (run-c '() (cons (list x t2) e1) (list t) (cons (list s e c) d))])]
  [(cons   t  c) (run-t t s e c d)]))

(define (run-d d v)
  (match d
  ['() v]
  [(cons (list s e c) d) (run-c (cons v s) e c d)]))

(define (normal-form t)
  (reify-closure (run-t t '() '() '() '())))

(require "../common/term-checks.rkt")

(check-normalizer-of? normal-form cbv-normal-forms)

