#lang racket

#|
"01_runs.rkt"

This file is a modification of "00_SECD.rkt":
+ transitions to run
+ dumps as lists
|#

(require "../common/common.rkt")
(require "../common/term.rkt")
(require "../common/closure.rkt")

(struct ap () #:transparent)

(define (run s e c d)
  (match* (s e c d)
  [(_ _ '() (cons (list s1 e1 c1) d1))                       (run (cons (car s) s1) e1 c1 d1)]
  [(_ _ (cons (*var x) c) _)                                 (run (cons (second (assoc x e)) s) e c d)]
  [(_ _ (cons (*lam x t) c) _)                               (run (cons (*closure (*lam x t) e) s) e c d)]
  [((list* (*closure (*lam x t) e1) t2 s) e (cons (ap) c) d) (run '() (cons (list x t2) e1) (list t) (cons (list s e c) d))]
  [(_ _ (cons (*app l r) c) _)                               (run s e (list* r l (ap) c) d)]
  [((list v) '() '() '())                                    v]))

(define (normal-form t)
  (reify-closure (run '() '() (list t) '())))

(require "../common/term-checks.rkt")

(check-normalizer-of? normal-form cbv-normal-forms)

