#lang racket

#|
"00_SECD.rkt"

SECD machine implemented from Peter Landin's
"The mechanical evaluation of expressions"
for pure λ-calculus
|#

(require "../common/common.rkt")
(require "../common/term.rkt")
(require "../common/closure.rkt")
(provide (all-defined-out))

(struct conf (s e c d) #:transparent)
(struct ap () #:transparent)

(define (load-term t)
  (conf '() '() (list t) #f))

(define (unload-value cf)
  (match cf
  [(conf (list v) '() '() #f) v]
  [_                         #f]))

(define (trans cf)
  (match cf
  [(conf s e '() (conf s1 e1 c1 d1))   (conf (cons (car s) s1) e1 c1 d1)]       ;1
  [(conf s e (cons (*var x) c) d)       (conf (cons (second (assoc x e)) s) e c d)] ;2a
  [(conf s e (cons (*lam x t) c) d)     (conf (cons (*closure (*lam x t) e) s) e c d)]     ;2b
  [(conf (list* (*closure (*lam x t) e1) t2 s) e (cons (ap) c) d)  (conf '() (cons (list x t2) e1) (list t) (conf s e c d))] ;2c1
  ; 2c2 skipped
  [(conf s e (cons (*app l r) c) d)     (conf s e (list* r l (ap) c) d)] ;2d
  
  [(conf (list v) '() '() #f) #f]))

(define (normal-form t)
  (reify-closure (unload-value (for-each-state (load-term t) trans identity))))

(require "../common/term-checks.rkt")

(check-normalizer-of? normal-form cbv-normal-forms)

