#lang racket

#|
"04_confs.rkt"

- translation into configuration datatype
- removal of the Reify frame
- Closure -> *closure
- unary Cache -> binary Cache
- Abs -> Cache on *closure
|#

(require "../common/common.rkt")
(require "../common/term.rkt")
(require "../common/closure.rkt")
(provide (all-defined-out))

(struct todo (t) #:transparent)
(struct done (v) #:transparent)

(struct Cache (l t) #:transparent)

(struct econf (t e s) #:transparent)
(struct cconf (s v) #:transparent)

(define (load-term t)
  (econf t (hasheq) '()))

(define (unload-value cf)
  (match cf
  [(cconf '() v) v]
  [_            #f]))

(define (rule-no-and-trans c)
  (match c
  [(econf (*app u v) e s)          (cons 1 (econf u e (cons (*app (*var 'hole) (*closure v e)) s)))] 
  [(econf (*lam x t) e s)          (cons 2 (cconf s (Cache (box (todo #f)) (*closure (*lam x t) e))))]
  [(econf (*var x)   e s) (let ([m (hash-ref e x (box (done (*var x))))]) (match (unbox m)
      [(todo (*closure v e))       (cons 3 (econf v e (cons (Cache m (*var 'hole)) s)))]
      [(done t)                    (cons 4 (cconf s t))]))]
  [(cconf (cons (Cache m (*var 'hole)) s) t)    (cons 5 (begin (set-box! m (done t)) (cconf s t)))]
  [(cconf (cons (*app (*var 'hole) ve) s) (Cache _ (*closure (*lam x t) e1)))
                                                       (cons 6 (econf t (hash-set e1 x (box (todo ve))) s))]
  [(cconf s                         (Cache c (*closure (*lam x t) e))) #:when (equal? (unbox c) (todo #f))
                                                       (cons 7 (let ([x1 (gensym x)])
                                                       (econf t
                                                           (hash-set e x (box (done (*var x1))))
                                                           (list* (*lam x1 (*var 'hole)) (Cache c (*var 'hole)) s))))]
  [(cconf s                         (Cache (box (done v)) (*closure (*lam x t) e))) (cons 8 (cconf s v))]
  [(cconf (cons (*app (*var 'hole) (*closure v e)) s) t)
                                        (cons 9 (econf v e (cons (*app t (*var 'hole)) s)))]
  [(cconf (cons (*app t  (*var 'hole)) s) v)  (cons 10 (cconf s (*app  t v)))]
  [(cconf (cons (*lam x1 (*var 'hole)) s) v)  (cons 11 (cconf s (*lam x1 v)))]
  [(cconf '() v) (cons #f #f)]))

(define (rule-no c)
  (car (rule-no-and-trans c)))
(define (trans c)
  (cdr (rule-no-and-trans c)))

(define (normalize t)
  (unload-value (for-each-state (load-term t) trans ignore)))

(require rackunit)
(require "../common/term-checks.rkt")

(check-normalizer-of? normalize complete-full-normal-forms)
(check-normalizer-of? normalize open-normal-forms)

(define (steps-for-family family ns)
  (map (λ (n) (count-bounces (load-term (family n)) trans)) ns))

(check-equal? ; c_n c_2 I
  (steps-for-family (λ (n) (*appseq (*Church n) (*Church 2) *id)) (range 1 10))
  (map (λ (n) (+ (* 10 (expt 2 n)) (* 5 n) 5)) (range 1 10)))
(check-equal? ; pred c_n
  (steps-for-family (λ (n) (*app *Church-Cregut-pred (*Church n))) (range 1 10))
  (map (λ (n) (+ (* 30 n) 41)) (range 1 10)))
(check-equal?
  (steps-for-family (λ (n) (*app *Church-pred (*Church n))) (range 2 10))
  (map (λ (n) (+ (* 37 n) 16)) (range 2 10)))
(check-equal? ; λx. c_n ω x
  (steps-for-family *explode1 (range 1 10))
  (map (λ (n) (+ (* 9 n) 15)) (range 1 10)))
(check-equal?
  (steps-for-family *explode3 (range 1 10))
  (map (λ (n) (+ (* 18 n) 14)) (range 1 10)))
(check-equal? ; c_n dub I
  (steps-for-family *explode4 (range 1 10))
  (map (λ (n) (+ (* 18 n) 15)) (range 1 10)))
(check-equal? ; c_n dub (λx. I x)
  (steps-for-family *implode2 (range 1 10))
  (map (λ (n) (+ (* 18 n) 20)) (range 1 10)))

