#lang racket

#|
"03_optimizations.rkt"

- inline apply-value
- inline apply
- inline memothunk
- App1 -> FRapp, Cont1 -> FLapp, Lam3 -> FLam
- FReify, Cont -> FReify, FLapp, Lam2 -> FReify, FLam, Halt1 ~> FReify
- inline continue3
- inline reify
- translation to Racket, FCache
- merge AbsClos with Fun
- inline force into FReify, (box (todo #f)), inline AbsClos clause of render
- match AbsClos in Abs, inline apply-closure, merge Abs and AbsClos into Abs
- inline render into force, inline force
- stack as frames list
|#

(require "../common/common.rkt")
(require "../common/term.rkt")

(struct todo (t) #:transparent)
(struct done (v) #:transparent)

(struct FReify () #:transparent)
(struct FCache (m) #:transparent)
(struct FLapp (t) #:transparent)
(struct FRapp (arg env) #:transparent)
(struct FLam (x1) #:transparent)
(struct Closure (arg e) #:transparent)
(struct VVar (x1) #:transparent)
(struct Abs (x b e c) #:transparent)

(define (eval env term s)
  (match term
    ({*var x} (let ([m (hash-ref env x {box (done {*var x})})])
          (match (unbox m)
              [(done v) (continue s v)]
              [(todo t) (match t
                  ({Closure arg env} (eval env arg (cons (FCache m) s)))
                  ({VVar x1}         (continue (cons (FCache m) s) {*var x1})))])))
    ({*app fn arg} (eval env fn (cons {FRapp arg env} s)))
    ({*lam x body} (continue s {Abs x body env (box (todo #f))}))))

(define (continue s1 v)
  (match s1
    [(cons (FCache m) s) (begin (set-box! m (done v)) (continue s v))]
    [(cons (FReify) s) (match v
        [{Abs x body env c} (match (unbox c)
            [(done v) (continue s v)]
            [(todo _) (let ([x1 (gensym x)])
                (eval (hash-set env x {box (todo {VVar x1})}) body (list* (FReify) (FLam x1) (FCache c) s)))])]
        [t          (continue s t)])]
    [(cons (FRapp arg e) s) (match v
        ({Abs x body env _}
            (eval (hash-set env x {box (todo {Closure arg e})}) body s))
        (t          (eval e arg (list* (FReify) (FLapp t) s))))]
    ((cons (FLapp t) s) (continue s {*app t v}))
    ((cons (FLam x1) s) (continue s {*lam x1 v}))
    ('() v)))

(define (normalize term) (eval (hasheq) term (list (FReify))))

(require "../common/term-checks.rkt")

(check-normalizer-of? normalize complete-full-normal-forms)
(check-normalizer-of? normalize open-normal-forms)

