#lang racket

#|
"00_nbe.rkt"

This is modified KNnamed/00_nbe.rkt.
|#

(require "../common/common.rkt")
(require "../common/term.rkt")

(struct  Abs (x t))
(struct todo (t))
(struct done (v) #:transparent)

(define (memothunk/c value?)
  (λ (v) (match v
           [(box (done v)) (value? v)]
           [(box (todo t)) (procedure? t)]
           [_ #f])))

(define (force mt)
  (match (unbox mt)
    [(done v) v]
    [(todo t) (let ([v (t)]) (set-box! mt (done v)) v)]))

(define (memothunk thunk)
  (box (todo thunk)))

(define (value? v)
  (match v
    [(Abs _ f)  (procedure? f)]
    [t          (neutral-term? t)]))

(define;/contract
  (reify v)
  ;(-> value? normal-term?)
  (match v
    [(Abs c _)  (force c)]
    [t          t]))

(define;/contract
  (apply-value v w)
  ;(-> value? (-> value?) value?)
  (match v
    [(Abs _ f)  (f w)]
    [t          (*app t (reify (w)))]))

(define;/contract
  (eval e t)
  ;(-> (hash/c identifier? (memothunk/c value?)) named-term? value?)
  (match t
    [(*var x)   (force (hash-ref e x (box (done (*var x)))))]
    [(*app t u) (apply-value (eval e t) (λ () (eval e u)))] 
    [(*lam x t) (let ([f (λ (v) (eval (hash-set e x (memothunk v)) t))])
                  (Abs (memothunk (λ () (let ([x1 (gensym x)])
                                          (*lam x1 (reify (f (λ () (*var x1))))))))
                       f))]))

(define;/contract
  (normalize t)
  ;(-> named-term? normal-term?)
  (reify (eval (hasheq) t)))

(require "../common/term-checks.rkt")

(check-normalizer-of? normalize complete-full-normal-forms)
(check-normalizer-of? normalize open-normal-forms)

