# Abstract Machines Workshop

This project contains the code accompanying the paper
*A Simple and Efficient Implementation of Strong Call by Need
by an Abstract Machine*.
It uses [Racket](https://racket-lang.org/) 8.5 programming language
(and [Python](https://www.python.org/) 3.9.2 with [matplotlib](https://matplotlib.org) and [pandas](https://pandas.pydata.org/) for plotting).

The virtual machine (VM) image presenting the project (available separately) contains also the latest version of Buszka & Biernacki's *Semantic Transformer* \[[BB21](https://doi.org/10.1007/978-3-030-98869-2_3)\] installed using Haskell's package manager [cabal](https://www.haskell.org/cabal/).
Please note: *Semantic Transformer* is a separate artefact with its own readme and installation guide available [here](https://github.com/mbuszka/semantic-transformer).

## Overview

This catalogue contains folders for implementations related to particular abstract machines ([SECD](SECD), [KN](KN), [KN with names](KNnamed), [RKNL](RKNL))
and a folder [`common`](common) containing definitions common for all the implementations (including definitions of terms, tests, etc.).

Most of the files of these subdirectories contain tests implemented with a built-in unit-testing framework [RackUnit](https://docs.racket-lang.org/rackunit/).
The file [`run_all_rkt.sh`](./run_all_rkt.sh) runs all the `*/*.rkt` files (including the tests).
The tests pass silently. The example concerning **Table 3.** of Section 4.2 below demonstrates how to make a test fail.

The file [`plot.py`](./plot.py) is a Python script to generate plots from a CSV file.
The catalogue [`lib`](lib) can be filled with the [`idl.rkt`](https://github.com/mbuszka/semantic-transformer/blob/6035960c4a59f82a99e36490f07cf3f46486c0a4/interpreters/lib/idl.rkt) file from *Semantic Transformer*
to make the `*/*.idl` files runnable.
VM image contains a folder [`semantic-transformer`](semantic-transformer) with the *Semantic Transformer* installation.

## Relationship with the paper

The higher-order normal-order normalizer from **Listing 1.** of Section 3.1 is located in the file [`KNnamed/00_nbe_standalone.rkt`](KNnamed/00_nbe_standalone.rkt).
It is a standalone version of the file [`KNnamed/00_nbe.rkt`](KNnamed/00_nbe.rkt) with removed contracts and tests,
and with added term constructors from the file [`common/term.rkt`](common/term.rkt).

The normalizer of **Listing 2.** of Section 3.2 similarly presents the code from the file [`RKNL/00_nbe.rkt`](RKNL/00_nbe.rkt).
Contracts are commented out because checking exponentially big normal forms would imply an exponential overhead.
However, the user can uncomment the contracts to additionally verify data consistency.

The code of **Listing 3.** of Section 3.3 is contained by the file [`RKNL/01_input.idl`](RKNL/01_input.idl).
It is an input for the *Semantic Transformer* tool and the expected output is [`RKNL/02_output.idl`](RKNL/02_output.idl).
Analogous `.idl` files can be found in [`KNnamed`](KNnamed) for reference as an example.

On the VM, one can change the working directory with `cd semantic-transformer` and then run `cabal run semt ../KNnamed/01_input.idl` or `cabal run semt ../RKNL/01_input.idl`.
This will create the output file [`semantic-transformer/out/01_input.rkt`](semantic-transformer/out/01_input.rkt) (it may trivially differ from the expected output).

The output is edited by hand to obtain a more compact version [`RKNL/03_optimizations.rkt`](RKNL/03_optimizations.rkt) (modifications are listed in the comment at the top of the file).
Finally, the *RKNL machine* from **Table 1.** of Section 4. with `econf` and `cconf` datatypes (representing configurations) and implicit store is implemented in [`RKNL/04_confs.rkt`](RKNL/04_confs.rkt).
Analogous implementation of Peter Landin's *SECD machine* \[[Lan64](https://doi.org/10.1093%2Fcomjnl%2F6.4.308)\] in [`SECD/00_SECD.rkt`](SECD/00_SECD.rkt) and a deconstruction of it in subsequent files of [`SECD`](SECD) are given for reference as an example.
Please note: The SECD machine is even not mentioned in the paper 
*A Simple and Efficient Implementation of Strong Call by Need
by an Abstract Machine*, so the example is addressed to readers already acquainted with SECD.

The numbers of steps presented in **Table 3.** of Section 4.2 are checked with tests in files [`KN/machine.rkt`](KN/machine.rkt) (columns of *normal order* and *KN*) and [`RKNL/04_confs.rkt`](RKNL/04_confs.rkt) (the column *RKNL*).
To easily confirm that tests are checked, one can change one of the given closed forms and run tests again, so then it should fail.

Tested term families and many others are defined in [`common/term.rkt`](common/term.rkt).
Corresponding test file [`common/test-term.rkt`](common/test-term.rkt) contains some examples of defined functions' usage.
Analogously, [`common/test-common.rkt`](common/test-common.rkt) tests and documents [`common/common.rkt`](common/common.rkt).
Please note: The repository is designed to be *self-documenting*.
To this end, many example use cases are given as appropriate unit tests.

An implementation of the *RKNL machine* with the explicit store is given in [`RKNL/05_locations.rkt`](RKNL/05_locations.rkt).
It also contains an implementation of the potential function from **Table 6.** of Section 5.4 as functions `phi-t`, `phi-v`, `phi-s`, `phi-σ`, and `phi-k`.
Tests at the end of the file verify the potential of selected terms.

A call `(generate-plot-data)` of the function `generate-plot-data` prints to the standard output data of the plot presented in **Figure 1.** of Section 5.4.
With command `racket RKNL/05_locations.rkt > plot_data.csv`, it can be saved to a file `plot_data.csv` if the call `(generate-plot-data)` is uncommented.
Then a command `python3 plot.py` can be used to reproduce the plot from the paper (the process generates some warnings) in the form of a PDF file.

A more inclined user can experiment with functions `generate-example-unicode` and `generate-example-latex` from [`RKNL/05_locations.rkt`](RKNL/05_locations.rkt) that help to generate Unicode and LaTeX examples akin to the one presented in **Table 2.** of Section 4.1. The Unicode trace on the VM may be unreadable because of the lack of Unicode support.
