#lang racket

#|
"00_nbe_standalone.rkt"
|#

(struct *var (x  ) #:transparent)
(struct *app (l r) #:transparent)
(struct *lam (x t) #:transparent)
(struct  Abs (x t))

(define (reify v)
  (match v
    [(Abs x f)  (let ([x1 (gensym x)])
                  (*lam x1 (reify (f (λ () (*var x1))))))]
    [t          t]))

(define (apply-value v w)
  (match v
    [(Abs _ f)  (f w)]
    [t          (*app t (reify (w)))]))

(define (eval e t)
  (match t
    [(*var x)   ((hash-ref e x))]
    [(*app t u) (apply-value (eval e t) (λ () (eval e u)))] 
    [(*lam x t) (Abs x (λ (v) (eval (hash-set e x v) t)))]))

(define (normalize t)
  (reify (eval (hasheq) t)))

