#lang racket

#|
"00_nbe.rkt"
|#

(require "../common/common.rkt")
(require "../common/term.rkt")

(struct Abs (x t))

(define (value? v)
  (match v
    [(Abs x f)  (and (symbol? x) (procedure? f))]
    [t          (neutral-term? t)]))

(define/contract (reify v)
  (-> value? normal-term?)
  (match v
    [(Abs x f)  (let ([x1 (gensym x)]) (*lam x1 (reify (f (λ () (*var x1))))))]
    [t          t]))

(define/contract (apply-value v w)
  (-> value? (-> value?) value?)
  (match v
    [(Abs _ f)  (f w)]
    [t          (*app t (reify (w)))]))

(define/contract (eval e t)
  (-> (hash/c identifier? (-> value?)) named-term? value?)
  (match t
    [(*var x)   ((hash-ref e x))]
    [(*app t u) (apply-value (eval e t) (λ () (eval e u)))] 
    [(*lam x t) (Abs x (λ (v) (eval (hash-set e x v) t)))]))

(define/contract (normalize t)
  (-> named-term? normal-term?)
  (reify (eval (hasheq) t)))

(require "../common/term-checks.rkt")

(check-normalizer-of? normalize complete-full-normal-forms)

