library(fst)
library(data.table)
library(survival)

args <- commandArgs(trailingOnly = TRUE)

input_path <- args[1]
formula_path <- args[2]
model_index <- eval(parse(text = args[[3]]))

output_path <- args[4]

print("Load formula")
f.index <- readRDS(formula_path)
print("Load input table")
df <- read_fst(input_path, columns = f.index$all.variables[[model_index]], as.data.table = T)

mod <- coxph(f.index$full.formula[[model_index]], data = df)

aic <- AIC(mod)
prstars <- function(x) {
    ifelse(x < .001, "***", ifelse(x < .01, "**", ifelse(x < .05, "*", "")))
}
prettymod <- function(model, type) {
    # i) pull summary stats
    model.sum <- summary(model)
    # ii) extract coefficients
    model.coef <- model.sum$coefficients
    # iii) format
    model.format <- model.coef
    varnames <- row.names(model.format)
    model.format <- data.table(model.format)
    model.format <- model.format[, .(
        variable = varnames,
        coefficient = sprintf("%.4f", (coef)),
        hazard.ratio = sprintf("%.3f", exp(coef)),
        significance = prstars(`Pr(>|z|)`)
    )]

    return(model.format)
}

log.lik <- logLik(mod)[1]
mod <- prettymod(mod, f.index$form[model_index])
est <- mod$coefficient[grep("^iv", mod$variable)]
results <- list(mod, aic, log.lik, est)


print("Save result")
saveRDS(results, output_path)