library(fst)
library(data.table)
library(tidyverse)

args <- commandArgs(trailingOnly=TRUE)

input_path <- args[1]

output_path <- args[2]

cleaned_df <- read_fst(input_path, as.data.table = T)

cormat <- cor(
    cleaned_df[, c("iv.pagerank.log","iv.hits.log","iv.cohits.log","iv.bgrm.log","iv.birank.log", "c.n.doc.count.log", "c.n.degree.log")],
    method='pearson'
)
row.names(cormat) <- c("PageRank", "HITS", "CoHITS", "BGRM", "BiRank", "Provider Count", "Transitive Ties")
colnames(cormat) <- c("PageRank", "HITS", "CoHITS", "BGRM", "BiRank", "Provider Count", "Transitive Ties")

# remove lower triangle
lower_tri<-cormat
lower_tri[upper.tri(lower_tri)]<-0
# Put into three columns
melted_cormat <- melt(lower_tri, na.rm = F, variable.factor=F)
# Format results
melted_cormat$val2 <- melted_cormat$value
melted_cormat$val2 <- sprintf("%.2f", melted_cormat$val2)
melted_cormat$val2[melted_cormat$Var1 == "Overdose"]  <- sprintf("%.3f", melted_cormat$value[melted_cormat$Var1 == "Overdose"])
# Erase duplicates from melted values and format
melted_cormat$var <- factor(melted_cormat$Var1, levels = unique(melted_cormat$Var1))
melted_cormat$value[melted_cormat$Var1 == melted_cormat$Var2] <- 0
melted_cormat$val2[melted_cormat$value==0] <- ""

ggheatmap <- ggplot(data = melted_cormat, aes(var, Var2, fill = value, label=val2))+
    geom_tile(color = "white")+
    scale_fill_gradient2(midpoint = 0, low = "#808080", high = "#808080", limit = c(-1,1), space = "Lab", name="Pearson\nCorrelation") +
    theme_minimal()+
    theme(axis.text.x = element_text( angle = 45, vjust = 1, size = 14, hjust = 1),
            axis.text.y = element_text(size = 14) #axis label text size
         )

p <- ggheatmap +
    geom_text(aes(var, Var2, label = val2), color = "black", size = 4.5,hjust=.5) +
        theme(
            text = element_text(family = "serif"),
            axis.title.x = element_blank(),
            axis.title.y = element_blank(),
            panel.grid = element_blank(),
            panel.border = element_blank(),
            panel.background = element_blank(),
            axis.ticks = element_blank(),
            legend.text = element_text(size = 15),
            legend.title = element_text(size = 15),
            plot.title = element_text(size=20, hjust=.38),
            plot.subtitle = element_text(size=20, hjust=.38),
            plot.margin = margin(.5, 4, 0, 0, "cm"))+
    guides(fill = guide_colorbar(barwidth = 3, barheight = 15))#+
ggsave(tsave1 <- file.path(output_path), p, width = 8*1.3, height = 5.5*1.3, units = "in")