library(fst)
library(data.table)
library(ggplot2)
library(tidyverse)

args <- commandArgs(trailingOnly=TRUE)

input_paths <- args[1:length(args)-1]

output_path <- tail(args, 1)

iv_name <- list()
aic <- list()
sig <- list()
for(i in 1:length(input_paths)){
    input_path <- input_paths[[i]]
    temp_table <- readRDS(input_path)
    iv_name[[i]] <- temp_table[[1]]$variable[[1]]
    sig[[i]] <- temp_table[[1]]$significance[[1]] != ''
    aic[[i]] <- temp_table[[2]]
}

weighted_table <- data.table(
    iv=unlist(iv_name),
    aic=unlist(aic),
    sig=unlist(sig)
)

weighted_table[, aic_rescale:=aic-min(aic)]

setorder(weighted_table, aic_rescale)

weighted_table[, IV := gsub(".logged.mme.log", " (Weighted)", iv)]
weighted_table[, IV := gsub("\\.log", "", IV)]

weighted_table[, IV := gsub("hits", "HITS", IV)]
weighted_table[, IV := gsub("coHITS", "CoHITS", IV)]
weighted_table[, IV := gsub("birank", "BiRank", IV)]
weighted_table[, IV := gsub("bgrm", "BGRM", IV)]
weighted_table[, IV := gsub("pagerank", "PageRank", IV)]

weighted_table$IV <- gsub("iv\\.", "", weighted_table$IV)

lims <- c(min(weighted_table$aic_rescale), max(weighted_table$aic_rescale))
dif <- lims[2] - lims[1]
adds <- dif/10
lims[2] <- lims[2] + adds

p1 <- ggplot(weighted_table, aes(x = reorder(IV, aic_rescale), y = aic_rescale)) +
    geom_point(stat = "identity", size = 2.5, color = ifelse(weighted_table$sig , "black", "grey60")) +
    theme_bw() +
    theme(text=element_text(family="serif"),
          axis.text = element_text(angle = 45, hjust = 1, size = 10),
          axis.text.x = element_text(angle = 45, hjust = 1),
          plot.title = element_text(hjust = 0.50)) +
          scale_y_continuous(limits = lims) +
          labs(x = "", y = "AIC - Minimum AIC (Smaller = Better Model Fit)")
ggsave(tsave1 <- file.path(output_path), p1, width = 6*1.2, height = 4*1.2, units = "in")