library(fst)
library(data.table)
library(scales)

args <- commandArgs(trailingOnly=TRUE)

input_path <- args[1]
part <- args[2]
output_path <- args[3]

print("Read data")
df <- read_fst(input_path, as.data.table = T, to = 1)

print("Pick variables for use in formulas")
dvs <- c("dv.io")
if(part == 'main'){
    controls <- "c.age + c.any.rx + c.cancer + c.female + c.hepc + c.hiv + c.mat.user + c.palliative.care + c.psych.disorder + c.year.quarter"
}else{
    # Remove c.hiv from the supp analysis since there is no overdose events for patients with hiv
    controls <- "c.age + c.any.rx + c.cancer + c.female + c.hepc + c.mat.user + c.palliative.care + c.psych.disorder + c.year.quarter"
}
network.controls <- "c.n.degree.log + c.n.doc.count.log"

ivs <- grep("^iv", names(df) , value = T)
ivs <- grep("log$", ivs , value = T)
ivs <- append("", ivs)

print("Create a data.frame with all combinations of dvs and ivs for use when creating formulas")
#base formula
f.index <- data.table(
    DV = rep(dvs, each = length(ivs)),
    IV = rep(ivs, length(dvs))
)

#create function to identify variables in formula
text.form <- function(formula){
    text <- paste(formula, collapse = "+")
    text <- gsub("\\~|\\+|\\|", ",", text)
    text <- gsub(" ", "", text)
    text <- gsub("^,,", "", text)
    text <- gsub("Surv\\(", "", text)
    text <- gsub("\\)", "", text)
    text <- gsub(",,", ",", text)
    text <- gsub("\\(1\\,","", text)
    unlist(strsplit(text, ","))
}

#create formulas
l.vars <- list()
l.formulas <- list()
for(i in 1:nrow(f.index)){
    #intialize formula
    if(f.index$IV[i] == ''){
        form <- paste("~", controls)
    }else{
        form <- paste("~", f.index$IV[i], "+", controls)
    }

    #add network controls
    form <- paste(form, "+", network.controls)

    #add formula specific syntax
    form <- paste("formula(Surv(time.id,", f.index$DV[i], ")", form)
    form <- gsub("\\+ c.year.quarter","",form)
    form <- paste(form, ")")

    # create formula and append to l.formulas
    assignment.text <- paste("l.formulas[[", i, "]]", "<-", form, sep = "")
    eval(parse(text = assignment.text))
    # identify all unique variables in formula
    l.vars[[i]] <- c(text.form(l.formulas[[i]]))
}

f.index$full.formula <- l.formulas
l.vars <- lapply(l.vars, function(x) x[x != ""])
f.index$all.variables <- l.vars

f.index$model.id <- 1:nrow(f.index)

print("Save data")
saveRDS(f.index, output_path)