# Introduction

This repo contains the code and data to reproduce the results in main text and supporting information in the paper "Comparing Measures of Centrality in Bipartite Social Networks: A Study of Drug Seeking for Opioid Analgesics."

# Data

The regression tables are stored in the folder `data`:

`reg_table_main.fst` contains the data for the main text.
`reg_table_supp.fst` contains the data for the supporting information.

# Code

The series of `*.R` scripts are used to process the regression tables, run the regression models, and generate the figures.

The workflow is organized by [snakemake](https://snakemake.readthedocs.io/en/stable/).
You can find the details about the workflow in `Snakefile`.
Once you have `snakemake`` installed, you can simply run

```sh
snakemake all -j1
```

to excute the whole workflow and generate the results.

# Dependency

The R scripts use some packages:

- fst
- data.table
- tidyverse
- survival
- scales

Make sure they are installed before you run the code.
