####
#### Format figures for eDNA-seq
#### 2022.05.12 revision for Environmental DNA
#### R 4.1.2
####

# Set working directory
if(basename(getwd()) != "FigCode") setwd("FigCode")

# Load libraries
## For general
library(tidyverse); packageVersion("tidyverse") # 1.3.1, 2021.8.25
library(lubridate); packageVersion("lubridate") # 1.8.0, 2021.11.10
## For image
library(ggimage); packageVersion("ggimage") # 0.3.0, 2021.12.8
library(magick); packageVersion("magick") # 2.7.3, 2021.12.8
## For ggplot
library(cowplot); packageVersion("cowplot") # 1.1.1, 2021.3.1
library(ggrepel); packageVersion("ggrepel") # 0.9.1, 2021.11.29
library(ggsci); packageVersion("ggsci") # 2.9, 2021.8.26
theme_set(theme_cowplot())

# Prepare output folders
fig_dir <- "00_RawFigs/"
fig_dir_out <- "00_FormattedFigs/"
# Generate output directory
dir.create(fig_dir_out)

# Prepare color palette
library(RColorBrewer); packageVersion("RColorBrewer") # 1.1.3, 2022.5.5
get_palette <- colorRampPalette(brewer.pal(8, "Paired"))


# <---------------------------------------------> #
#  Load figure objects
# <---------------------------------------------> #
# Experiment II
fig_exp2_summary <- readRDS(paste0(fig_dir, "9_2_Fig_Exp2_SummaryReads.obj"))
fig_exp2_idhop <- readRDS(paste0(fig_dir, "9_2_Fig_Exp2_IndexHoppingRate.obj"))


# <---------------------------------------------> #
# Experiment 2
# <---------------------------------------------> #
## Compile data
idhop_df <- fig_exp2_idhop[[2]]$data %>% mutate(purif = purification_after_1st_pcr)
## Purification method
idhop_df$purif <- as.character(idhop_df$purif)
idhop_df$purif[idhop_df$purif == "ExoSAP"] <- "w/ exonuclease"
idhop_df$purif[idhop_df$purif == "none"] <- "w/o exonuclease"
idhop_df$purif <- factor(idhop_df$purif, levels = c("w/ exonuclease", "w/o exonuclease"))
## Temperature
idhop_df$temp <- as.character(idhop_df$temperature)
idhop_df$temp[idhop_df$temp == "room_temp"] <- "22˚C"
idhop_df$temp[idhop_df$temp == "on_ice"] <- "4˚C"
idhop_df$temp <- factor(idhop_df$temp, levels = c("4˚C", "22˚C"))
## Specify legend names
legend_names <- "Purification and\ntemperature"
legend_labels <- c("On ice after exonuclease",
                   "At RT after exonuclease",
                   "On ice without exonuclease",
                   "At RT without exonuclease")
plot_cols <- c("royalblue", "skyblue", "red3", "darkred")
(fig_exp2_idhop[[3]] <- idhop_df %>%
    ggplot(aes(x = time, y = Abundance * 100,
               group = purif:temp:time,
               color = purif:temp,
               fill = purif:temp)) +
    geom_point(pch = 19, size = 2, alpha = 0.7, position = position_jitterdodge(jitter.width = 0.2)) +
    scale_color_manual(values = plot_cols, name = legend_names, labels = legend_labels) +
    scale_fill_manual(values = plot_cols, name = legend_names, labels = legend_labels) +
    ylab("Proportion of sequence reads of each OTU\ngenerated by tag-jumping (%)") +
    scale_y_log10() +
    xlab("Time after pooling (min)") +
    NULL)

idhop_df %>% group_by(test_category) %>% summarize(max = max(Abundance*100))
idhop_df %>% filter(Abundance > 0) %>% group_by(test_category) %>% summarize(count = n())


# <---------------------------------------------> #
# Save figures
# <---------------------------------------------> #
# Main figures
## Figure 3
ggsave(file = sprintf("%s/Figure_03.pdf", fig_dir_out),
       plot = fig_exp2_idhop[[3]], width = 10, height = 6)
