'''
This folder contains all the details necessary for the 
different heuristics to make their choices.
'''


import numpy as np
from math import log
import itertools
import random

from regex import A
from heuristic_tools import multiplyList, all_combinations, minimum_indices, aveg_of_not_zero


def choose_variables_minimizing(degrees_list, measure='gmods', var_list=''):
    '''Given a list the degrees of polynomials returns the list of variables that minimise the measure desired'''
    if measure != 'greedy_sotd':
        nvar = len(degrees_list[0][0]) # the number of variables will be the same everywhere, we check the first monomial of the first polynomial
    else:
        nvar = len(degrees_list[0][0][0]) 
    if var_list == '': # if the value is the default one
        var_list = range(nvar)

    if measure == 'gmods':
        sum_degree_polys = [sum([max([monomial[var] for monomial in polynomial]) for polynomial in degrees_list]) for var in range(nvar)] # for each variable, the total degree of each polynomial is computed. Then for each variable this values are added because is what we really care about. 
        return [var for var in var_list if var in minimum_indices(sum_degree_polys)] # var_list is filtered
    if measure == 'ali_aveg':
        av_degree_polys_with_var = [aveg_of_not_zero([max([monomial[var] for monomial in polynomial]) for polynomial in degrees_list]) for var in range(nvar)] # for each variable, the total degree of each polynomial is computed. Then for each variable this values are added because is what we really care about.
        return [var for var in var_list if var in minimum_indices(av_degree_polys_with_var)] # var_list is filtered
    elif measure == 'greedy_logmods':
        sum_degrees_overall_polys = [sum([log(max([1]+[monomial[var] for monomial in polynomial])) for polynomial in degrees_list]) for var in range(nvar)] # for each variable, the total degree of each polynomial is computed. Then for each variable this values are added because is what we really care about.
        return [var for var in var_list if var in minimum_indices(sum_degrees_overall_polys)]
    elif measure == 'brown1':
        max_degrees_polywise = [max([max([monomial[var] for monomial in polynomial]) for polynomial in degrees_list]) for var in range(nvar)] # for each variable, the maximum degree in the polynomials is computed.
        return [var for var in var_list if var in minimum_indices(max_degrees_polywise)]
    elif measure == 'brown2':
        max_degrees_polywise = [max([max([0]+[monomial[var] for monomial in polynomial]) for polynomial in degrees_list]) for var in range(nvar)] # for each variable, the maximum degree in the polynomials is computed.

        degrees_of_monomials_with_max_degrees = [max([max([0]+[sum(monomial) for monomial in polynomial if monomial[var]==max_degrees_polywise[var]]) for polynomial in degrees_list]) for var in range(nvar)] # for each variable, the maximum degree in the polynomials is computed.
        return [var for var in var_list if var in minimum_indices(degrees_of_monomials_with_max_degrees)]
    elif measure == 'brown3':
        number_appearances = [sum([sum([np.sign(monomial[var]) for monomial in polynomial]) for polynomial in degrees_list]) for var in range(nvar)] # the number of monomials in which the variables appear is counted
        return [var for var in var_list if var in minimum_indices(number_appearances)]
    elif measure == 'avegavegdeg':
        aveg_degrees_overall_polys = [np.average([np.average([monomial[var] for monomial in polynomial]) for polynomial in degrees_list]) for var in range(nvar)] # for each variable, the total degree of each polynomial is computed. Then for each variable this values are added because is what we really care about. 
        return [var for var in var_list if var in minimum_indices(aveg_degrees_overall_polys)] # var_list is filtered
    elif measure == 'sumsumdeg':
        sum_degrees_overall_polys = [sum([sum([monomial[var] for monomial in polynomial]) for polynomial in degrees_list]) for var in range(nvar)] # for each variable, the total degree of each polynomial is computed. Then for each variable this values are added because is what we really care about. 
        return [var for var in var_list if var in minimum_indices(sum_degrees_overall_polys)] # var_list is filtered
    elif measure == 'greedy_sotd':
        sum_total_degrees = [sum([sum(monomial) for polynomial in possible_proj_set for monomial in polynomial]) for possible_proj_set in degrees_list]
        return [var for var in var_list if var in minimum_indices(sum_total_degrees)] # var_list is filtered
    elif measure == 'random':
        return [random.choice(var_list)]
    elif measure == 'first':
        return [var_list[0]]
    elif measure == 'last':
        return [var_list[-1]]


def greedy_choose_variable(poly_list, heuristic='gmods'):
    '''Given a list of polynomials returns the variable that the gmods heuristic would choose to project next'''
    if heuristic == 'gmods':
        order_measure = ['gmods', 'first']
    elif heuristic == 'ali_aveg':
        order_measure = ['ali_aveg', 'first']
    elif heuristic == 'greedy_logmods':
        order_measure = ['greedy_logmods', 'first']
    elif heuristic == 'brown':
        order_measure = ['brown1', 'brown2', 'brown3', 'first']
    elif heuristic == 'greedy_sotd':
        order_measure = ['greedy_sotd', 'first']
    elif type(heuristic)==int:
        measures = ['gmods', 'brown1','brown3','avegavegdeg'] # add
        measures = ['brown1', 'brown2', 'brown3']
        all_pos = all_combinations(measures)
        order_measure = list(all_pos[heuristic])+['first']
    else:
        raise Exception("The heuristic chosen is not available.")
    
    if heuristic != 'greedy_sotd':
        degrees_list = [[monomial[:-1] for monomial in polynomial] for polynomial in poly_list] # the same list without the coefficients
        nvar = len(degrees_list[0][0]) # the number of variables will be the same everywhere, we check the first monomial of the first polynomial
    else:
        degrees_list = [[[monomial[:-1] for monomial in polynomial] for polynomial in polys] for polys in poly_list] # the same list without the coefficients
        nvar = len(degrees_list[0][0][0]) 
    if degrees_list == []: # idk why this happens but we just return this sentence
        return "The list given is empty"
    best_vars = range(nvar)
    while len(best_vars)>1:
        measure = order_measure.pop(0)
        best_vars = choose_variables_minimizing(degrees_list, measure=measure, var_list=best_vars)
    return best_vars[0]


##
# Rules for expensive heuristics
##

def old_mods_guess(mrd):#mrd->old_mods_relevant_degrees
    '''Computes the best order according to the old_mods heuristic (multiplication of relative degrees).'''
    old_mods_values = [multiplyList([sum([degree for degree in level_mrd if degree!=0]) for level_mrd in proj_mrd]) for proj_mrd in mrd]
    return min(range(len(old_mods_values)), key=old_mods_values.__getitem__) # returns the index with the smallest value in the list old_mods_values


def logmods_guess(mrd):
    '''Computes the best order according to the logmods heuristic (multiplication of the logarithm of relative degrees).'''
    logmods_values = [multiplyList([sum([log(degree) for degree in level_mrd if degree!=0]) for level_mrd in proj_mrd]) for proj_mrd in mrd]
    return min(range(len(logmods_values)), key=logmods_values.__getitem__) # returns the index with the smallest value in the list logmods_values


def mods_guess(mrd):
    '''Computes the best ordering minimizing the maximum number of cells in the final CAD.'''
    mods_values = [multiplyList([1+2*sum([degree for degree in level_mrd if degree!=0]) for level_mrd in proj_mrd]) for proj_mrd in mrd]
    return min(range(len(mods_values)), key=mods_values.__getitem__) # returns the index with the smallest value in the list old_mods_values


def super_mods_guess(mrd):
    '''Computes the best ordering minimizing the maximum number of cells in all the CADs needed to build the final CAD.'''
    mods_values = [sum([multiplyList([1+2*sum([degree for degree in level_mrd if degree!=0]) for level_mrd in proj_mrd[:i+1]]) for i in range(len(proj_mrd))])for proj_mrd in mrd]
    return min(range(len(mods_values)), key=mods_values.__getitem__) # returns the index with the smallest value in the list old_mods_values


def acc_logmods_guess(mrd):
    '''Computes the best order according to the logmods heuristic (multiplication of the logarithm of relative degrees).'''
    acc_logmods_values = [multiplyList([1+2*sum([log(degree) for degree in level_mrd if degree!=0]) for level_mrd in proj_mrd]) for proj_mrd in mrd]
    return min(range(len(acc_logmods_values)), key=acc_logmods_values.__getitem__) # returns the index with the smallest value in the list logmods_values
