'''
This file studies the metrics of the virtual_best and the random choices.
'''

from heuristic_tools import finding_time_limit, compute_markups
def compute_extra_metrics(heuristic, virtual_best_timings, timings, number_no_timedout, useful_timings):

    if heuristic == 'virtual_best':
        metrics = compute_virtual_best_metrics(heuristic, virtual_best_timings)
    elif heuristic == 'random':
        metrics = compute_average_metrics(heuristic, virtual_best_timings, timings, number_no_timedout, useful_timings)
    return metrics

def compute_virtual_best_metrics(heuristic, virtual_best_timings):

    name = 'virtual-best'
    no_samples = len(virtual_best_timings)
    accuracy_heuristic = 1
    terminatings_without_cost, terminatings, timeouts_30, timeouts_60 = no_samples, no_samples, 0, 0
    markup_without_cost, markup = 0, 0
    total_time = round(sum(virtual_best_timings))
    total_time_without_cost = round(sum(virtual_best_timings))
    perc_found_1, perc_found_2, perc_found_3 = 1, 1, 1 

    
    return name, accuracy_heuristic, terminatings_without_cost, terminatings, timeouts_30, timeouts_60, markup_without_cost, markup, total_time_without_cost, total_time, perc_found_1, perc_found_2, perc_found_3, no_samples


def compute_average_metrics(heuristic, virtual_best_timings, timings, number_no_timedout, useful_timings):

    no_samples = len(virtual_best_timings)
    accuracy_heuristic = 1/6
    prob_timeouts = [pos_timeout/6 for pos_timeout in number_no_timedout]
    terminatings = no_samples - sum(prob_timeouts)
    terminatings_without_cost = terminatings
    timeouts_30 = sum([prob_timeout for prob_timeout,timing in zip(prob_timeouts,timings) if finding_time_limit(timing)==30])
    timeouts_60 = sum([prob_timeout for prob_timeout,timing in zip(prob_timeouts,timings) if finding_time_limit(timing)==60])
    expected_timings = [sum(useful_timing)/len(useful_timing) for useful_timing in useful_timings]
    markup = compute_markups(virtual_best_timings, expected_timings)
    markup_without_cost = markup 
    total_time = round(sum(expected_timings))
    total_time_without_cost = round(sum(expected_timings))
    perc_found_1, perc_found_2, perc_found_3 = 1/6, 2/6, 3/6

    return heuristic, accuracy_heuristic, terminatings_without_cost, terminatings, timeouts_30, timeouts_60, markup_without_cost, markup, total_time_without_cost, total_time, perc_found_1, perc_found_2, perc_found_3, no_samples