% Fig 4,6,7,8,9,10,11 quantile (R2012)
clear close all

dCH2O_Q1 = nan(11,24); dCevap_Q1 = nan(11,24); dCtrans_Q1 = nan(11,24); dLE_Q1 = nan(11,24);
dCH2O_Q3 = nan(11,24); dCevap_Q3 = nan(11,24); dCtrans_Q3 = nan(11,24); dLE_Q3 = nan(11,24);
day_data = 24;
for fignum = [4,6,7,8,9,10,11]
  if fignum == 4
    fprintf('PREC\n')
    load('CL_TCCIP_c0_end_prec_transform_raw.mat');
  elseif fignum == 6
    fprintf('T\n')
    load('CL_TCCIP_c0_end_T_transform_raw.mat')
  elseif fignum == 7
    fprintf('RH\n')
    load('CL_TCCIP_c0_end_RH_transform_raw.mat')
  elseif fignum == 8
    fprintf('T_RH\n')
    load('CL_TCCIP_c0_end_TRH_transform_raw.mat')
  elseif fignum == 9
    fprintf('T3_RH\n')
    load('CL_TCCIP_c0_end_TtripleRH_transform_raw.mat')
  elseif fignum == 10
    fprintf('2xCO2\n')
    load('CL_2xCO2_transform_raw.mat')
  elseif fignum == 11
    fprintf('T_RH_PREC_2xCO2\n')
    load('CL_TCCIP_c0_end_TRHprec_2xCO2_transform_raw.mat')
  end 
  CH2O_e = [nan(7,1);CH2O(1:end-7)];
  Cevap_e = [nan(7,1);Cevap(1:end-7)];
  Ctrans_e = [nan(7,1);Ctrans(1:end-7)];
  Gevap_e = [nan(7,1);Gevap(1:end-7)];
  LE_e = Cevap_e+Ctrans_e+Gevap_e;
  clear Swnet Lwnet Swdw Swup U10 WIND QDRIP QINTR RSSUN RSSHA PCO2 LAISUN LAISHA
  clear Cevap Ctrans Gevap CH2O LE QBOT Q2M RH2M Prec SH TBOT T2M PBOT photo TV TG

  load('CL_TCCIP_ctl_transform_raw.mat');
  CH2O_c = [nan(7,1);CH2O(1:end-7)];
  Cevap_c = [nan(7,1);Cevap(1:end-7)];
  Ctrans_c = [nan(7,1);Ctrans(1:end-7)];
  Gevap_c = [nan(7,1);Gevap(1:end-7)];
  LE_c = Cevap_c+Ctrans_c+Gevap_c;
  clear Swnet Lwnet Swdw Swup U10 WIND QDRIP QINTR RSSUN RSSHA
  clear Cevap Ctrans Gevap CH2O LE QBOT Q2M RH2M Prec SH TBOT T2M PBOT photo TV TG
  % -----------------------------------------
  dCH2O = CH2O_e-CH2O_c; dCevap = Cevap_e-Cevap_c; dCtrans = Ctrans_e-Ctrans_c; dLE = LE_e-LE_c;
  for i = 1:day_data
    dCH2O_Q1(fignum,i) = quantile(dCH2O(i:day_data:end),0.25);
    dCevap_Q1(fignum,i) = quantile(dCevap(i:day_data:end),0.25);
    dCtrans_Q1(fignum,i) = quantile(dCtrans(i:day_data:end),0.25);
    dLE_Q1(fignum,i) = quantile(dLE(i:day_data:end),0.25);

    dCH2O_Q3(fignum,i) = quantile(dCH2O(i:day_data:end),0.75);
    dCevap_Q3(fignum,i) = quantile(dCevap(i:day_data:end),0.75);
    dCtrans_Q3(fignum,i) = quantile(dCtrans(i:day_data:end),0.75);    
    dLE_Q3(fignum,i) = quantile(dLE(i:day_data:end),0.75);
  end

end
save('Fig_4_6_7_8_9_10_11_quantile.mat','dCH2O_Q1','dCevap_Q1','dCtrans_Q1','dLE_Q1','dCH2O_Q3','dCevap_Q3','dCtrans_Q3','dLE_Q3')

