% Fig 5
clear 
close all

%% load
load('CL_TCCIP_ctl_transform_raw.mat');
Cevap_c = [nan(7,1);Cevap(1:end-7)];
Ctrans_c = [nan(7,1);Ctrans(1:end-7)];
Gevap_c = [nan(7,1);Gevap(1:end-7)];
LE_c = Cevap_c+Ctrans_c+Gevap_c;
clear Swnet Lwnet Swdw Swup U10 WIND QDRIP QINTR RSSUN RSSHA LAISHA LAISUN
clear Cevap Ctrans Gevap CH2O LE QBOT Q2M RH2M Prec SH TBOT T2M PBOT photo TV TG PCO2

diurnal_Cevap_c = nan(24,1); 
diurnal_Ctrans_c = nan(24,1); 
diurnal_Gevap_c = nan(24,1); 
diurnal_LE_c = nan(24,1); 
for i=1:24
    diurnal_Cevap_c(i,1)=mean(Cevap_c(i:24:end),'omitnan');
    diurnal_Ctrans_c(i,1)=mean(Ctrans_c(i:24:end),'omitnan');
    diurnal_Gevap_c(i,1)=mean(Gevap_c(i:24:end),'omitnan');
    diurnal_LE_c(i,1)=mean(LE_c(i:24:end),'omitnan');
end
%% plot
figure
plot(0:1:23,diurnal_Cevap_c,'-o','linewidth',3,'MarkerSize',5)
hold on
grid on
plot(0:1:23,diurnal_Ctrans_c,'-o','linewidth',3,'MarkerSize',5,'Color',[0 0.5 0])
plot(0:1:23,diurnal_Gevap_c,'-o','linewidth',3,'MarkerSize',5,'Color',[0.929 0.694 0.125])
plot(0:1:23,diurnal_LE_c,'--','linewidth',2,'Color',[0.494 0.184 0.556])
xlim([0 23])
ylim([-50 300])
set(gca,'xTick',(0:2:23),'fontsize',24);
set(gca,'yTick',[0:100:300],'fontsize',24);
xlabel('hour','fontsize',22);
ylabel('flux (W/m^2)','fontsize',24);
legend({'Canopy E','Transpir.','Ground E','total LH'},'location','NorthEast','fontsize',24)
title({'Diurnal Cycle of Latent Heat Flux Partition'},'fontsize',22,'Interpreter','none');
handaxes2 = axes('Position',[0.25 0.64 0.25 0.25])
plot(0:1:23,diurnal_Gevap_c,'-o','linewidth',1.5,'MarkerSize',2.5,'Color',[0.929 0.694 0.125])
xlim([0 23])
ylim([0 5])
set(gca,'xTick',(0:3:23),'fontsize',14);
set(gca,'yTick',(0:1:5),'fontsize',14);
xlabel('hour','fontsize',13);
ylabel('Ground E. (W/m^2)','fontsize',14);
grid on
img = gcf; 
print(img, '-dpdf', '-r600', './Fig_5.pdf')
