% Fig 3
clear
close all

%% load
load('CL_surfobs_raw.mat');
CH2O_CL = [nan(15,1);CH2O(1:end-15)];
load('CLatm_LHC_prec_raw.mat');
CH2O_LHC = [nan(15,1);CH2O(1:end-15)];
load('CLatm_LHC_precdouble_raw.mat');
CH2O_LHC2 = [nan(15,1);CH2O(1:end-15)];
load('CLatm_LHC_prec_add05toCLamount_raw.mat');
CH2O_LHCadd = [nan(15,1);CH2O(1:end-15)];

CW_CL = nan(1,48); CW_LHC = nan(1,48); CW_LHC2 = nan(1,48); CW_LHCadd = nan(1,48);
day_data = 48;
for i = 1:day_data
    CW_CL(i) = mean(CH2O_CL(i:day_data:end),'omitnan');
    CW_LHC(i) = mean(CH2O_LHC(i:day_data:end),'omitnan');
    CW_LHC2(i) = mean(CH2O_LHC2(i:day_data:end),'omitnan');
    CW_LHCadd(i) = mean(CH2O_LHCadd(i:day_data:end),'omitnan');    
end

%% plot
figure
plot(0:0.5:23.5,CW_CL,'-o','linewidth',3,'MarkerSize',5,'Color',[0.929 0.694 0.125]); 
hold on
grid on
plot(0:0.5:23.5,CW_LHCadd,'-o','linewidth',3,'MarkerSize',5,'Color',[0 179 205]/225); 
plot(0:0.5:23.5,CW_LHC2,'-o','linewidth',3,'MarkerSize',5,'Color',[0 146 3]/255);
plot(0:0.5:23.5,CW_LHC,'-o','linewidth',3,'MarkerSize',5,'Color',[0 0.447 1]);
xlim([0 23.5])
ylim([0 1])
set(gca,'xTick',(0:2:23),'fontsize',22);
set(gca,'yTick',(0:0.2:1),'fontsize',22);
xlabel('hour','fontsize',22);
ylabel('(mm)','fontsize',22);
legend({'CL','LHC_light','LHCx2','LHC'},'location','NorthEast','fontsize',16,'Interpreter','none')
title({['Rainfall sensitivity tests']; ['Diurnal Cycle of Canopy Water']},'fontsize',22);
img = gcf; 
print(img, '-dpdf', '-r600', './Fig_3.pdf')
