% Fig 2
clear
close all

%% load
load('CL_surfobs_raw.mat');
CH2O_CL = [nan(15,1);CH2O(1:end-15)];
load('LHC_nodew_new_raw.mat');
CH2O_LHC = [nan(15,1);CH2O(1:end-15)];

CW_CLc = nan(1,48); CW_LHC = nan(1,48);
day_data = 48;
for i = 1:day_data
    CW_CLc(i) = mean(CH2O_CL(i:day_data:end),'omitnan');
    CW_LHC(i) = mean(CH2O_LHC(i:day_data:end),'omitnan');
end

%% plot
figure
plot(0:0.5:23.5,CW_CLc,'g-o','linewidth',3,'MarkerSize',5);
hold on
grid on
plot(0:0.5:23.5,CW_LHC,'-^','Color',[0 0.5 0],'linewidth',3,'MarkerSize',5);
xlim([0 23.5])
ylim([0 1])
set(gca,'xTick',(0:2:23),'fontsize',24);
set(gca,'yTick',(0:0.2:1),'fontsize',24);
xlabel('hour','fontsize',22);
ylabel('(mm)','fontsize',24);
legend({'Chi-Lan','Lien-Hua-Chih'},'location','NorthEast','fontsize',24)
title({['Diurnal Cycle of Canopy Water']; ['in Chi-Lan & Lien-Hua-Chih']},'fontsize',22);
img = gcf; 
print(img, '-dpdf', '-r600', './Fig_2.pdf')
