% Fig 10
clear
close all

%% load
load('CL_2xCO2_transform_raw.mat');
Cevap_e = [nan(7,1);Cevap(1:end-7)];
Ctrans_e = [nan(7,1);Ctrans(1:end-7)];
CH2O_e = [nan(7,1);CH2O(1:end-7)];
Q2M_e = [nan(7,1);Q2M(1:end-7)*1000];
RH2M_e = [nan(7,1);RH2M(1:end-7)];
TV_e = [nan(7,1);TV(1:end-7)];
PBOT_e = [nan(7,1);PBOT(1:end-7)];
photo_e = [nan(7,1);photo(1:end-7)];
RSSUN_e = [nan(7,1);RSSUN(1:end-7)];
RSSHA_e = [nan(7,1);RSSHA(1:end-7)];
clear Swnet Lwnet Swdw Swup U10 WIND QDRIP QINTR RSSUN RSSHA
clear Cevap Ctrans Gevap CH2O LE QBOT Q2M RH2M Prec SH TBOT T2M PBOT photo TV TG

load('CL_TCCIP_ctl_transform_raw.mat');
Cevap_c = [nan(7,1);Cevap(1:end-7)];
Ctrans_c = [nan(7,1);Ctrans(1:end-7)];
CH2O_c = [nan(7,1);CH2O(1:end-7)];
Q2M_c = [nan(7,1);Q2M(1:end-7)*1000];
RH2M_c = [nan(7,1);RH2M(1:end-7)];
TV_c = [nan(7,1);TV(1:end-7)];
PBOT_c = [nan(7,1);PBOT(1:end-7)];
photo_c = [nan(7,1);photo(1:end-7)];
RSSUN_c = [nan(7,1);RSSUN(1:end-7)];
RSSHA_c = [nan(7,1);RSSHA(1:end-7)];
clear Swnet Lwnet Swdw Swup U10 WIND QDRIP QINTR RSSUN RSSHA
clear Cevap Ctrans Gevap CH2O LE QBOT Q2M RH2M Prec SH TBOT T2M PBOT photo TV TG

day_data = 24;
% Q2M, RH2M--Qs2M [annual diurnal cycle with std]
Lv = 2.5*10^6; Rv = 461; T0 = 273.15;
Qs2M_c = Q2M_c./RH2M_c*100;
Qs2M_e = Q2M_e./RH2M_e*100;
QsTV_c = 6.11*100*exp(-(Lv./Rv)*((1./TV_c)-1/T0))*0.622./PBOT_c; QsTV_c = QsTV_c*1000; % kg/kg-->g/kg
QsTV_e = 6.11*100*exp(-(Lv./Rv)*((1./TV_e)-1/T0))*0.622./PBOT_e; QsTV_e = QsTV_e*1000; % kg/kg-->g/kg
dQ2M = Q2M_e-Q2M_c; dQs2M = Qs2M_e-Qs2M_c; dQsTV =  QsTV_e-QsTV_c; 
ano_Q2M = nan(24,1); ano_Qs2M = nan(24,1); ano_QsTV = nan(24,1);
for i = 1:day_data
    ano_Q2M(i,1) = mean(dQ2M(i:day_data:end),'omitnan');
    ano_Qs2M(i,1) = mean(dQs2M(i:day_data:end),'omitnan');
    ano_QsTV(i,1) = mean(dQsTV(i:day_data:end),'omitnan');
end
dCH2O = CH2O_e-CH2O_c; dCevap = Cevap_e-Cevap_c; dCtrans = Ctrans_e-Ctrans_c;
ano_CH2O = nan(1,24); ano_Cevap = nan(1,24); ano_Ctrans = nan(1,24);
ano_RSSUN = nan(1,24); ano_RSSHA = nan(1,24);
for i = 1:day_data
    ano_CH2O(i) = mean(dCH2O(i:day_data:end),'omitnan');
    ano_Cevap(i) = mean(dCevap(i:day_data:end),'omitnan');
    ano_Ctrans(i) = mean(dCtrans(i:day_data:end),'omitnan');
end
for i = 1:24
    ano_RSSUN(i) = mean((RSSUN_e(i:24:end)-RSSUN_c(i:24:end)),'omitnan');
    ano_RSSHA(i) = mean((RSSHA_e(i:24:end)-RSSHA_c(i:24:end)),'omitnan');
end
diurnal_photo_c = nan(24,1); diurnal_photo_e = nan(24,1);
for i = 1:24
    diurnal_photo_c(i) = mean(photo_c(i:24:end),'omitnan');
    diurnal_photo_e(i) = mean(photo_e(i:24:end),'omitnan');
end
load('Fig_4_6_7_8_9_10_11_quantile.mat');
time = 0:1:23;
%% plot
% plot
hfig = figure('units','inches','position',[5 0 10 20]);
% subplot 1
sf1 = subplot(3,2,1);
plot(time,ano_CH2O,'linewidth',1.5,'MarkerSize',5,'Color',[0 0.45 0.74])
hold on
grid on
upper_C = dCH2O_Q3(10,:);
lower_C = dCH2O_Q1(10,:);
p_C = patch([time fliplr(time)],[upper_C,fliplr(lower_C)],[0 0.45 0.74]);
p_C.EdgeColor = 'none';
p_C.FaceAlpha = 0.2; % transparency of patch
plot([0 23],[0 0],'k--','linewidth',1)
xlim([0 23])
ylim([-0.04 0.04])
set(sf1,'xTick',(0:2:23),'fontsize',16);
set(sf1,'yTick',-0.04:0.02:0.04,'fontsize',16);
xlabel('hour','fontsize',16);
ylabel('(mm)','fontsize',16);
title({'(a) Diurnal Cycle of Canopy Water';'Anomaly'},'fontsize',14,'Interpreter','none');
% subplot 2
sf2 = subplot(3,2,2);
plot(0:1:23,ano_Cevap,'linewidth',1.5,'MarkerSize',5,'Color','b')
hold on
grid on
plot(0:1:23,ano_Ctrans,'linewidth',1.5,'MarkerSize',5,'Color',[0 0.5 0])
upper_Ce = dCevap_Q3(10,:);
lower_Ce = dCevap_Q1(10,:);
p_Ce = patch([time fliplr(time)],[upper_Ce,fliplr(lower_Ce)],[0 0.45 0.74]);
p_Ce.EdgeColor = 'none';
p_Ce.FaceAlpha = 0.2; % transparency of patch
upper_Ct = dCtrans_Q3(10,:);
lower_Ct = dCtrans_Q1(10,:);
p_Ct = patch([time fliplr(time)],[upper_Ct,fliplr(lower_Ct)],[0 0.5 0]);
p_Ct.EdgeColor = 'none';
p_Ct.FaceAlpha = 0.3; % transparency of patch
plot([0 23],[0 0],'k--','linewidth',1)
xlim([0 23])
ylim([-40 20])
set(sf2,'xTick',(0:2:23),'fontsize',16);
set(sf2,'yTick',[-40:20:20],'fontsize',16);
xlabel('hour','fontsize',16);
ylabel('(W/m^2)','fontsize',16);
lh2 = legend({'Canopy E','Transpir.'},'location','North','fontsize',10,'Orientation','horizontal');
title({'(b) Diurnal Cycle of Canopy Evapotranspiration';'Anomaly'},'fontsize',14,'Interpreter','none');
% subplot 3
sf3 = subplot(3,2,3);
plot(0:1:23,ano_Q2M,'--','linewidth',1.5,'MarkerSize',5,'Color',[0 0 1])
hold on
grid on
plot(0:1:23,ano_QsTV,'linewidth',1.5,'MarkerSize',5,'Color',[0 0.7 0])
plot([0 23],[0 0],'k--','linewidth',1)
xlim([0 23])
ylim([-0.05 0.8])
set(sf3,'xTick',(0:2:23),'fontsize',16);
set(sf3,'yTick',(0:0.2:0.8),'fontsize',16);
xlabel('hour','fontsize',16);
ylabel('(g/kg)','fontsize',16);
lh3=legend({'Q @ 2m','Qs of vegetation T'},'location','NorthWest','fontsize',10);
title({'(c) Diurnal Cycle of (Saturated) Specific Humidity';'Anomaly'},'fontsize',14,'Interpreter','none');
% subplot 4
sf4 = subplot(3,2,4);
plot(0:1:23,ano_RSSUN,'r','linewidth',1.5)
hold on
grid on
plot(0:1:23,ano_RSSHA,'k','linewidth',1.5)
plot([0 23],[0 0],'k--','linewidth',1)
xlim([0 23])
ylim([-500 2500])
set(sf4,'xTick',(0:2:23),'fontsize',16);
set(sf4,'yTick',(-500:500:2500),'fontsize',16);
xlabel('hour','fontsize',16);
ylabel('(s/m)','fontsize',16);
legend({'SUNLIT','SHADED'},'location','NorthWest','fontsize',10)
title({'(d) Diurnal Cycle of Stomatal Resistance';'Anomaly'},'fontsize',14,'Interpreter','none');
% subplot 5
sf5 = subplot(3,2,5);
plot(0:1:23,diurnal_photo_c,'--','linewidth',1.5,'color',[0 0.9 0])
hold on
grid on
plot(0:1:23,diurnal_photo_e,'linewidth',1.5,'color',[0 0.9 0])
xlim([0 23])
ylim([0 38])
set(sf5,'xTick',(0:2:23),'fontsize',16);
set(sf5,'yTick',(0:5:35),'fontsize',16);
xlabel('hour','fontsize',16);
ylabel('(\mumol/m^2s)','fontsize',16);
legend({'CTL','2xCO2'},'location','NorthWest','fontsize',10)
title({'(e) Diurnal Cycle of Photosynthesis'},'fontsize',14);
set(gcf,'PaperUnits','inches');
set(gcf,'PaperPosition',[0 0 18 18])
set(gcf,'PaperSize',[18 18])
img = gcf; 
img.PaperUnits = 'inches';  
img.PaperPosition = [0 0 18 18]; 
img.Units = 'inches'; 
img.PaperSize=[16 20];  
print(img, '-dpdf', '-r600', './Fig_10.pdf')
