import json
import os

# type alias for traces
Trace = list[str]

def save_program(trace: Trace, file: str = "program.py") -> None:
    """Writes the corresponding turtle instructions to a file."""
    with open(file, 'w') as f:
        print("import turtle", file=f)
        print("distance: int = 50", file=f)
        print("angle: int = 90", file=f)
        print("turtle.speed(1)", file=f)
        for t in trace:
            if t == "fd":
                print("turtle.fd(distance)", file=f)
            elif t == "bk":
                print("turtle.bk(distance)", file=f)
            elif t == "lt":
                print("turtle.lt(angle)", file=f)
            elif t == "rt":
                print("turtle.rt()", file=f)
            elif t == "pu":
                print("turtle.pu()", file=f)
            elif t == "pd":
                print("turtle.pd()", file=f)
            else:
                print("Error", t, file=f)


# get user inputs
h, v = map(lambda s: int(s.strip()), input("Enter H, V (Horizontal, Vertical): ").split(","))

trace = input("Enter comma separated trace: ")
trace = ",".join(map(lambda s: s.strip(), trace.split(",")))

end_coords = input("Enter end point as x, y: ")

# must not have spaces between x,y here
obs = input("Enter obstacles as x1,y1 x2,y2, etc: ").split()

with open("modified_core_turtle.csp", 'w') as out:
    print(f"H = {h}", file=out)
    print(f"V = {v}", file=out)

    with open("core_turtle.csp") as infile:
        for l in infile:
            if "START" in l:
                print(f"Turtle_nav({end_coords})(d) = goal -> Turtle_nav({end_coords})(d)", file=out)
                for o in obs:
                    print(f"Turtle_nav({o})(d) = SKIP", file=out)
                continue
            print(l, end='', file=out)

    print(f"assert Turtle_main(0, 0)(E) :[has trace] <{trace}>", file=out)


os.system("/Applications/FDR4.app/Contents/MacOS/refines --quiet --format json modified_core_turtle.csp > trace_refines_output.txt")
with open("trace_refines_output.txt") as f:
    refines_json = json.load(f)

# refines_json["results"][n]["result"] == 0 if failed
# refines_json["results"][n]["result"] == 1 if succeeded

trace_result = refines_json["results"][1]["result"]
if trace_result == 0:
    print("Assertion failed: not a possible trace ❌")
elif trace_result == 1:
    print("Assertion succeeded: possible trace ✅")

goal_result = refines_json["results"][0]["result"]
if goal_result == 0:
    print("Assertion failed: cannot reach goal ❌")
elif goal_result == 1:
    print("Assertion succeeded: can reach goal ✅")

if trace_result == 1:
    save_program(trace.split(','), file="trace_program.py")
    os.system("python3 -i trace_program.py")
