# Requirements
- [Python 3](https://www.python.org/)
- [FDR](https://cocotec.io/fdr/)


# Steps before running
- Download the files and place them in a directory together.
- In line 58 in interactive.py the section '/Applications/FDR4.app/Contents/MacOS/refines' should be changed if not being run on a Mac or if FDR was installed to a different location. Change it to whatever is necessary to invoke the [refines](https://cocotec.io/fdr/manual/command_line.html#command-line) command on your system. Don't change the flags or anything after that segment.
- Sometimes the first time when attempting to import the turtle module, there will be an error that says the `tkinter` module is not found. The exact solution depends on your operating system but a quick search will provide installation instructions.

# Running
Run `python3 interactive.py` at the command prompt in the directory with both files and then enter information as prompted.
If the plan entered is valid (i.e. a possible trace) then it will also automatically run this plan as a turtle program.
This is saved in `trace_program.py` if you want to run it again.

The possible trace elements are fd (forward), bk (backward), lt (left), rt (right), pu (penup), and pd (pendown).
Only the two letter abbreviated versions are accepted by the program.
The obstacles prompt can be left blank, but if obstacles are entered make sure they are written with no space between the two coordinates (e.g x,y) but with a space between every new pair of coordinates (e.g x1,y1 x2,y2).


## Example

```
Enter H, V (Horizontal, Vertical): 3, 3
Enter comma separated trace: pu, fd, fd, pd, bk
Enter end point as x, y: 2, 2
Enter obstacles as x1,y1 x2,y2, etc: 1,2 1,1 2,1
Assertion succeeded: possible trace ✅
Assertion failed: cannot reach goal ❌
```
