## Southern Africa Power Pool GridPath Model Input Data
This data repository holds data for the paper Chowdhury, A.K., Deshmukh, R., Wu, G., Uppal, A., Mileva, A., Curry, T., Armstrong, L., Galelli, S., and Kudakwashe, N. (2022) “Enabling a low-carbon electricity system for Southern Africa”, Joule.

These data can be used in conjunction with the GridPath (version v0.9.0) model. 

The GridPath model is available at [https://github.com/blue-marble/gridpath](https://github.com/blue-marble/gridpath).

Code and data maintained by [Clean Energy Transformation Lab (CETlab) University of California Santa Barbara] (https://cetlab.es.ucsb.edu).

### Key input data and assumptions :
(Refer to the Joule manuscript for more details)

(1) 1_base_12day.csv at `system_load/system_load` contains hourly electricity demand time series for each country and investment period projected from actual 2018 data collected from the national utilities of Southern Africa Power Pool (SAPP) member countries except DRC and Botswana (unavailable) for which we used respective data of Angola and South Africa. Time is in South African Standard Time. Demand projections based on annual growth rates and demand forecasts reported in [SAPP Pool Plan 2017](https://www.sapp.co.zw/sapp-pool-plan-0).

(2) csv files at `project/project_specified_capacity` contain installed generation capacities, aggregated by countries and technologies from plant-scale data adopted from SAPP Pool Plan 2017. Retirement of installed capacities over the investment periods is implemented exogenously by applying maximum economic lifetime of technologies, adopted from a report by National Renewable Energy Laboratory (NREL), available at [https://www.nrel.gov/docs/fy16osti/64472.pdf](https://www.nrel.gov/docs/fy16osti/64472.pdf).

(3) csv file at `project/project_specified_fixed_cost` contains annual fixed costs (USD/mw-year) of installed generators, adopted from [Integrated Resource Plan (IRP) 2019 of South Africa](http://www.energy.gov.za/IRP/2019/IRP-2019.pdf).

(4) csv files at `project/project_new_potential` contain capacities of new candidate generators. The candidate thermal projects are based on country-wise existing capacities and resources, according to SAPP Pool Plan 2017 from which the candidate hydropower projects are also adopted. Candidate battery storage, oil, and diesel projects are considered for all countries. Candidate solar and wind projects are identified by using MapRE, a geospatial tool available at [https://github.com/cetlab-ucsb/mapre](https://github.com/cetlab-ucsb/mapre). Vintage years of hydropower projects vary between 2020-2040, as in SAPP Pool Plan 2017.

(5) csv files at `project/project_new_cost` contain annualized real costs (USD/mw-year) of new candidate projects, estimated based on the overnight capital costs adopted from SAPP Pool Plan 2017. In the Reference scenario, costs of solar, wind, and battery projects are assumed to follow 'Low' projection of NREL's Annual Technology Baseline (ATB) Data 2019, whereas costs of other technologies are assumed to remain unchanged. These csv files also contains lifetime of the candidate projects, adopted from IRP 2019.

(6) csv files at `project/project_hydro_operational_chars` contain monthly capacity factors of installed and candidate hydropower plants. The monthly capacity factors are simulated by VIC-Res (a hydrologic and water management model) based on a historical average climate condition and assumed to remain static over the investment period. The four subscenarios represent average, wet, dry, and a higher capacity factor for Inga than what is assumed in the SAPP Plan. The VIC-Res model is available at [https://github.com/kamal0013/VICRes](https://github.com/kamal0013/VICRes). The VIC-Res input data are described in Chowdhury et al. *Joule* (2022).

(7) csv files at `project/project_variable_generator_profiles` contain month-hourly capacity factors of installed and candidate solar and wind projects, simulated by MapRE based on 2018 weather data from ERA5 to keep correlation with 2018 demand patterns. The month-hourly profiles of solar and wind capacity factors are selected for the same dates for which the electricity demand profiles are selected. The input data of MapRE are described in Chowdhury et al. *Joule* (2022).

(8) csv files at `project/project_operational_chars` contain several technical and economic parameters including ramping up/down rates, minimum up/down times, variable operating and maintenance (OM) costs, storage charging and discharging efficiencies, etc., most of which are adopted from IRP 2019 and SAPP Pool Plan 2017, while missing data are taken from global sources.

(9) csv files at `fuels/project_fuel_prices` contain fossil fuel prices for each investment period, estimated based on the 2017 fuel price and forcasted growth rate data from SAPP pool plan 2017.

(10) csv files at `fuels/project_fuels` contain CO2 emission rates (ton/MMBtu) of each fossil fuel as reported by Energy Information Administration, raw data available at [EIA](https://www.eia.gov/tools/faqs/faq.php?id=73t=11).

(11) csv files at `transmission/transmission_specified_capacity` contain capacities of existing and planned transmission interconnection lines, adopted from the [SAPP website](http://www.sapp.co.zw/transfer-limits).

(12) csv files at `transmission/transmission_new_cost` contain annualized real cost (USD/mw-year) and lifetime of new candidate interconnection lines, based on [The Western Electricity Coordinating Council (WECC)'s Substation Capital Cost Calculator](https://www.wecc.org/Administrative). Annualized costs are scaled by ratios of thermal and applicable transfer limits along each corridor based on data from SAPP at [http://www.sapp.co.zw/transfer-limits](http://www.sapp.co.zw/transfer-limits).

(13) csv files at `transmission/transmission_operational_chars` contain transmission loss factors, estimated as 1% per 100 miles according to NREL's Regional Energy Deployment System (ReEDS) model as reported at [https://www.nrel.gov/docs/fy21osti/78195.pdf](https://www.nrel.gov/docs/fy21osti/78195.pdf). Lengths of the interconnectors are estimated using centroids of countries.

(14) csv files at `policy/rps` contain the renewable or clean portfolio targets.

(15) csv files at `reliability/prm` contain the planning reserve margin (prm) targets.

### Scenario descrptions
The following scenarios are included in this model.
(full description of the scenarios are available at Table 1 in Chowdhury et al. *Joule* (2022))

**Scenario code**: Scenario name

1. *env_r65_prm15_c0p0_t1nn*: Static Costs
2. *env_r65_prm15_t1*: Existing Transmission (Tx)
3. *env_r65_prm15_t2_nonewtx2020*: Planned Tx
4. *env_r65_prm15_t1nn*: Reference
5. *env_r55_prm15_t1nn*: Coal Ret. 55y
6. *env_r45_prm15_t1nn_noret2020*: Coal Ret. 45y
7. *env_r65_prm15_rps80_t1nn*: Clean 80%
8. *env_r45_prm15_t1*: Coal Ret. 45y, Existing Tx
9. *env_r65_prm15_c0p0_t2*: Static Costs, Planned Tx
10. *env_r65_prm15_c0p0_t1*: Static Costs, Existing Tx
11. *env_r65_prm15_c0p1_t1nn*: RE Static Costs, Fossil Price Increases
12. *env_r65_prm15_c1p0_t1nn*: RE Costs Decreasing, Static Fossil Prices 
13. *env_r65_prm15_intrate_t1nn*: Country-specific interest rates
14. *env_r65_prm15_dry_t1nn*: Hydro Dry Years
15. *env_r65_prm15_wet_t1nn*: Hydro Wet Years
16. *env_r65_prm15_limgas_t1nn*: Limited Natural Gas
17. *env_r45_prm15_limgas_t1nn*: Limited Natural Gas, Coal Ret. 45y