##MODULE(help) SCPPack
##HALFLINE This package solves Set Covering Problem (SCP) and Set Covering Problem with Reasons (SCPR).
##AUTHOR AmirHosein Sadeghimanesh
##DATE May 2022
##CALLINGSEQUENCE
##- SCPPack:-'command'( 'args' )
##- SCPPack[ 'command' ]( 'args' )
##- 'command'( 'args' )
##DESCRIPTION
##- See the Demo Maple Worksheet.
##REFS
##- AmirHosein Sadeghimanesh, Matthew England, \"__"`An SMT solver for non-linear real arithmetic inside Maple/`"__\", 2022.


unprotect('SCPPack'):

SCPPack := module()

    option package:

    description "This package solves Set Covering Problem (SCP) and Set Covering Problem with Reasons (SCPR).":

     local
        Next_k_choice_r,
        ConjunctionMaker,
        Exactly_k_truth_formula,
        SubstituteAllArray,
        SCPRNSAT_ConstrMaker,
        LegacyFixer,
        SCPRNLinearized_sub,
        ModuleLoad: # local procedures

     export 
        SCPSimple,
        SCPRBasic,
        SCPRNSAT,
        SCPRNLinearized,
        SCPR:

    # actions to be done prior to loading this module
        
    ModuleLoad := proc()

        if Logic:-Satisfy( Logic:-`&or`( Logic:-`&and`( X, Logic:-`&not`( Y ) ), Logic:-`&and`( Logic:-`&not`( X ), Y ) ), method = "legacy" ) = {X = false, Y = false} then
            LegacyFixer():
        end if:

    end proc:

    ModuleLoad():

    # end of the module load section


# Getting the directory where this file, "main.mpl" is located.
kernelopts( includepath = currentdir() ): # all paths in the next lines are relative to this directory.
# including functions.
### The simple Set Covering Problem.
$include "SimpleSCP\\SCPSimple.mm"
### Combinatorial tools.
$include "CombinatorialTools\\Next_k_choice_r.mm"
### Logical tools.
$include "LogicalTools\\ConjunctionMaker.mm"
$include "LogicalTools\\Exactly_k_truth_formula.mm"
$include "LogicalTools\\LegacyFixer.mm"
### String tools.
$include "StringTools\\SubstituteAllArray.mm"
### SCPR: SCP with Reasons.
$include "SCPR\\SCPRBasic.mm"
$include "SCPR\\SCPRNSAT_ConstrMaker.mm"
$include "SCPR\\SCPRNSAT.mm"
$include "SCPR\\SCPRNLinearized_sub.mm"
$include "SCPR\\SCPRNLinearized.mm"
$include "SCPR\\SCPR.mm"

    # end of the package
end module;

protect('SCPPack'):