##PROCEDURE(help) SubstituteAllArray
##HALFLINE This procedure applies the Maple\'s "StringTools:-SubstituteAll" on an Array of strings instead of a single string and also accepts several substituation rulls at the same time.
##AUTHOR AmirHosein Sadeghimanesh
##DATE May 2022
##CALLINGSEQUENCE
##- SubstituteAllArray( 'stringArray', 'oldValues', 'newValues' )
##PARAMETERS
##- 'stringArray' : an array of strings.
##- 'oldValues'   : an array of strings.
##- 'newValues'   : an array of strings.
##RETURNS(help)
##- an array of strings.
##DESCRIPTION
##- This procedures recieves three arrays of strings, the length of the second and the third arrays should be the same. It searches for the strings of the second array in the strings of the first array and replaces all of them with their corresponding strings in the third array. This procedure uses Maple\'s "StringTools:-SubstituteAll", with the difference that it applies it on several strings at the same time with several substituation rules.
##EXAMPLES
##> libname ,= "C:\\Home\\DEWCADCoventry GitHub\\Packages\\SCPPack":
##> with( SCPPack ):
##> kernelopts( opaquemodules = false ):
##> A := Array([ "x__1 + x__2 = 3", "x__1 * x__2 < 0", "x__1, x__2 > -1" ]):
##> B := SCPPack:-SubstituteAllArray( A, Array([ "x__1", "x__2" ]), Array([ "y__1", "y__2" ]) );
##< Vector[row](3, ["y__1 + y__2 = 3", "y__1 * y__2 < 0", "y__1, y__2 > -1"])
##SEEALSO
##- "StringTools:-SubstituteAll"

SubstituteAllArray := proc(
    stringArray :: Array( string ),
    oldValues   :: Array( string ),
    newValues   :: Array( string )
    )
    :: Array( string ):

    description "This procedure receives three arrays of strings as its inputs. It finds all instances of the strings of the second array in the strings of the first array and replaces them with the strings in the third array.":

	local
        i              :: posint,
        j              :: posint,
        nn             :: nonnegint,
        mm             :: nonnegint,
        str            :: string,
        newStringArray :: Array( string ):

	nn := numelems( stringArray ):
	mm := numelems( oldValues ):

	if numelems( newValues ) <> mm then
		error "Length of the array for the new values must be equal to the length of the array for the old values.":
	end if:

	newStringArray := Array([ seq(str, str in stringArray) ]):

	for i from 1 by 1 to nn do
		for j from 1 by 1 to mm do
			newStringArray[i] := StringTools:-SubstituteAll( newStringArray[i], oldValues[j], newValues[j] ):
		end do:
	end do:

	return( newStringArray ):

end proc: