##PROCEDURE(help) ConjunctionMaker
##HALFLINE This procedure converts a binary vector to a conjunction of literals. The output is a string that can be parsed to a logical formula with the logical operators of the Logic package of Maple, i.e. '&and' and '&not'.
##AUTHOR AmirHosein Sadeghimanesh
##DATE May 2022
##CALLINGSEQUENCE
##- ConjunctionMaker( 'vec' )
##PARAMETERS
##- 'vec' : a binary list or array.
##RETURNS(help)
##- a string that can be parsed to a logical formula with logical operations from Maple\'s "Logic" package.
##DESCRIPTION
##- Let __"v=(v_1,...,v_n)"__ be a binary vector and __"y_1,...,y_n"__, __"n"__ boolean variables. We want a conjunction of literals, __"&and;_(i=1)^n a_i"__, where __"a_i"__ is __"y_i"__ if __"v_i=1"__, and __"&not; y_i"__ otherwise.
##- This procedure receives a binary vector and returns a string that can be parsed to the associated conunction formula introduced above to the input vector.
##EXAMPLES
##> libname ,= "C:\\Home\\DEWCADCoventry GitHub\\Packages\\SCPPack":
##> with( SCPPack ):
##> kernelopts( opaquemodules = false ):
##> SCPPack:-ConjunctionMaker( [1, 1, 0, 1, 0] );
##< "Logic:-`&and`( y__1, y__2, Logic:-`&not`( y__3 ), y__4, Logic:-`&not`( y__5 ))"
##SEEALSO
##- "Logic:-Import"

ConjunctionMaker := proc(
    vec :: {list( {0, 1} ), Array( {0, 1} )},
    r   :: posint := numelems( vec )
    )
    :: string:

    description "This procedure receives a binary vector of length r and then returns a string which can be parsed to a logic formula (with notations of Logic pacakage of Maple) as a conjunction of r literals. The literals for the ones in the input vector are 'y__i', and for the zeroes are negated.":

	local
        formula :: string,
        i       :: posint:

	formula := "Logic:-`&and`( ":

	for i from 1 by 1 to r do

		if vec[i] = 0 then
			formula := cat( formula, "Logic:-`&not`( y__", i, " )"):
		else
			formula := cat( formula, "y__", i ):
		end if:

		if i <> r then
			formula := cat( formula, ", " ):
		end if:

	end do:

	formula := cat( formula, ")" ):

	return( formula ):

end proc: