% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantile_matrix.R
\name{quantiles_matrix}
\alias{quantiles_matrix}
\title{Quantile Matrix Function}
\usage{
quantiles_matrix(
  data,
  coordinate,
  index,
  distance = NULL,
  NN = NULL,
  min_percentile = 0.1,
  max_percentile = 0.9,
  quantile_number = 21,
  method = pca_,
  ...
)
}
\arguments{
\item{data}{a data frame containing the expression information for each cell, like proteins, genes. \cr
This data frame doesn't contains any other columns except expressions, like indices of cells or coordinates of cells.}

\item{coordinate}{the coordinates of the corresponding cells in the \strong{data} argument. \cr
It includes two columns with specific names, the first of which is x coordinates of cells,\cr
and the second of which is the y coordinates of cells.}

\item{index}{the indices of the corresponding cells in the \strong{data} argument.}

\item{distance}{the maximal radius of the neighborbood from the center cell. \cr
When we try to find a neighborhood for a particular cell, this cell is called the center cell.\cr
The cells that are more than the given raidus from the center cell are not be included in the center cell's neighborhood. \cr
At least one of \strong{NN} and \strong{dustance} arguments should be specified.}

\item{NN}{the number of the nearest neighbors. The default value is NULL. \cr
It the value is not NULL, the nearest neighborhood method will be applied when we determine the neighborhood for each cell \cr
Only the given number of the closest cells will be included in the center cell's neighborhood. \cr
At least one of \strong{NN} and \strong{dustance} arguments should be specified.}

\item{min_percentile}{the minimal percentile. The default value is 0.1.}

\item{max_percentile}{the maximal percentile. The default value is 0.9.}

\item{quantile_number}{the number of quantiles for each variable. \cr
It is used in the function \strong{seq(min_percentile, max_percentile, length.out = quantile_numbers)} to get the given number of quantiles.}

\item{method}{the dimension reduction function for the \strong{data} argument. \cr
The default method is Principal Component Analysis using \strong{pca_} function in this package.}

\item{...}{other parameters passed to the \strong{method} argument.}
}
\value{
a neighborhood quantile matrix. Each row represents quantiles of reduced features in the neighborhood of one cell. \cr
The first is the number of cells in the corresponding neighborhood, which is used to check whether there are some abnormal neighborhoods.
}
\description{
This function is used for get the neighborhood quantile matrix for the raw spatial omics dataset. \cr
}
\details{
The spatial omics dataset could be divided into two parts, the expression matrix and the coordinates. \cr
Firstly, the dimension reduction method like Principle Component Analysis will be applied to the expression matrix. \cr
Then, the neighborhood for each cell will be extracted according to the distance between them. \cr
Next, in each neighborhood, tens of quantiles of each principal component are calculated, which are treated as \cr
neighborhood information vector for each cell. \cr
The final output is a neighborhood quantile matrix, each row of which is the neighborhood quantile vector of \cr
principal components for each cell.
}
