% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_matrix.R
\name{network_matrix}
\alias{network_matrix}
\title{Calculate Network Statistics Matrix}
\usage{
network_matrix(
  coordinate,
  index,
  radius = NULL,
  NN = NULL,
  edge,
  fun = centralities,
  length_output = 30,
  name_output = NULL
)
}
\arguments{
\item{coordinate}{a data frame containing cell indices and x and y coordinates which are labeled as \strong{index}, \strong{x_center} and \strong{y_center}, respectively.}

\item{radius}{the maximal radius length of a neighborhood. The cells whose distance to the center cell is larger than this length are not \cr
included in the neighborhood.}

\item{NN}{the number of nearest neighbors. If not NULL, only the nearest NN cells will be included in neighborhood.}

\item{edge}{the maximal length of the network edge.}

\item{fun}{the function which calculates the statistics of a network. \cr
Two arguments are supposed to be in this function. The first one is a network object \cr
and the second one is an index indicating the statistics of which vertex (cell) should be calculated. \cr
The default function is \strong{centralities}.}

\item{length_output}{the number of statistics calculated in the argument \strong{fun}. \cr
The default value is 30, which is the number of statistics in the \strong{centralities} function of this package.}

\item{name_output}{the names of statistics calculated in the argument \strong{fun}.}
}
\value{
a network statistics matrix, each rows of it representing network statistics of the neighborhood network of a single cell.
}
\description{
This function is aimed at calculating network statistics of the neighborhood \cr
network of each cell. The output is a network statistics matrix.
}
