% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NBF_vis.R
\name{NBF_vis}
\alias{NBF_vis}
\title{Neighborhood-Based Featurization Visualization}
\usage{
NBF_vis(matrix, origin_data, var_names)
}
\arguments{
\item{matrix}{a statistics matrix. It should be rescaled. \cr
For example, it could be the rescaled quantiles network centralities matrix.}

\item{origin_data}{a data frame. It is the origin dataset of cell expressions, like proteins and genes. \cr
Column \strong{index}, \strong{Group}, \strong{x_center} and \strong{y_center} should be included.}

\item{var_names}{the names of columns about expressions like proteins or genes in the argument \strong{origin_data}.}
}
\value{
an interactive shiny app for the UMAP embeddings.
}
\description{
The function could apply UMAP to the featurization matrix of a special omics dataset. \cr
This matrix could be a neighborhood matrix, which is the combination of the quantile \cr
matrix and network matrix (from quantile_matrix and network_matrix, respectively) \cr
Then, a shiny app will visualize the UMAP embeddings of the spatial omics data.
}
