#####
#
# "Climate change mitigation targets compromise forest ecosystem services and biodiversity"
# Additional graphic for supplementary material for some forest variables over time
# 2021-12-17
#
#####


# Basic forest variables - as questioned by the Reviewer of NatSus
# This includes the following variables over time & scenario & climate:
# - avg. harvest
# - avg. increment
# - avg. standing volume
# - avg. share of deciduous volume (%)

# Represented countries:
# - Finland
# - Germany
# - Norway
# - Sweden

library(dplyr)
library(ggplot2)
library(tidyr)
library(ggpubr)
library(RColorBrewer)





# wide to long data format

df.forestStatl <- df.forestStat %>% gather("indicator","areaWeightedAverage", 5:9)


# ------------
# Plot function for forest attirbutes/indicators  
# ------------



plotfct_individual_ind <- function( INDICATOR, df, COUNTRY) {
  
  if (INDICATOR == "Harvested_V"){
    YLAB <- expression(m^{3}~ha^{-1}~year^{-1})
    TITLE <- "Harvested roundwood"
  } else if (INDICATOR == "V" ) {
    YLAB <- expression(m^{3}~ha^{-1})
    TITLE <- "Standing volume"
  } else if (INDICATOR == "i_Vm3" ) {
    YLAB <- expression(m^{3}~ha^{-1}~year^{-1})
    TITLE <- "Increment"
  } else if (INDICATOR == "V_deadwood") {
    YLAB <- expression(m^{3}~ha^{-1})
    TITLE <- "Deadwood volume"
  } else if (INDICATOR == "prc_V_deciduous") {
    YLAB <- "% of standing volume"
    TITLE <- "Deciduous share"
  } 
 
  # Filter country
  df <- df %>% 
    filter(country %in% COUNTRY) %>% 
    # adjust printing names
    mutate(policy_plot = ifelse(policy %in% "BAU", "NFS",
                                ifelse(policy %in% "Biodiv", "BDS", "BES"))) %>% 
    mutate(scenario_plot = ifelse(scenario %in% "noCC", "1p5", "NDC")) %>% 
    mutate(OptApproach_plot = ifelse(OptApproach %in% "v1", "bottom-up", "top-down"))
  # order factor level
  df$policy_plot <- factor(df$policy_plot, levels = c("NFS", "BDS", "BES"))
 
  # 
  plot <- df %>%
    filter(indicator %in% INDICATOR) %>% 
    ggplot(aes(year, areaWeightedAverage)) +
    
    geom_line( aes(color = policy_plot, linetype = scenario_plot)) + #
    
    theme_bw() +
    theme(axis.text.x = element_text(angle = 90),
          axis.title.x=element_blank(),
          #panel.border = element_blank(), axis.line = element_line(color = "grey"),axis.ticks = element_line(color = "grey"),
          panel.grid = element_blank()
          ) +
    scale_linetype_manual("Mitigation target",values=c("solid", "dashed"), labels = c("1p5 (RCP1.9)" , "NDC (RCP4.5)") )+
    #scale_linetype_manual("Globiom", values=c("solid", "dashed"))+
    scale_color_brewer("Policy",palette="Set1") +
    scale_x_continuous(breaks=c(seq(min(df$year),max(df$year), by = 10) ))  +
    #expand_limits(x = c(2016, 2116)) +
    facet_grid(.~OptApproach_plot) +
    ylab(YLAB) +
    labs(subtitle = TITLE)
  
  if(INDICATOR %in% c("i_Vm3")){ # the one in the bottom row center - with legend
    
    plot <- plot + theme(legend.position = "right") 
    return(plot)
    
  } else {
    
    plot <- plot <- plot + theme(legend.position = "none") 
    return(plot)
    
  }
  
}


# ------------
# call the function for Finland
# ------------
plot.harv_fin <- plotfct_individual_ind("Harvested_V", df.forestStatl, "Finland")
plot.incr_fin <- plotfct_individual_ind("i_Vm3", df.forestStatl, "Finland")
plot.vol_fin <- plotfct_individual_ind("V", df.forestStatl, "Finland")
plot.decid_fin <- plotfct_individual_ind("prc_V_deciduous", df.forestStatl, "Finland")

plot.forestInd_fin <- egg::ggarrange(plot.harv_fin ,  plot.incr_fin, plot.vol_fin, plot.decid_fin, nrow = 4, ncol=1)
                                 
ggsave(plot = plot.forestInd_fin, paste0(outp_path,"plot.forestInd_fin.jpg"), width=7.5, height=10  )                               
                                 
                                 
# ------------
# call the function for Norway
# ------------
plot.harv_nor <- plotfct_individual_ind("Harvested_V", df.forestStatl, "Norway")
plot.incr_nor <- plotfct_individual_ind("i_Vm3", df.forestStatl, "Norway")
plot.vol_nor <- plotfct_individual_ind("V", df.forestStatl, "Norway")
plot.decid_nor <- plotfct_individual_ind("prc_V_deciduous", df.forestStatl, "Norway")

plot.forestInd_nor <- egg::ggarrange(plot.harv_nor ,  plot.incr_nor, plot.vol_nor, plot.decid_nor, nrow = 4, ncol=1)

ggsave(plot = plot.forestInd_nor, paste0(outp_path,"plot.forestInd_nor.jpg"), width=7.5, height=10  )  


# ------------
# call the function for Sweden
# ------------
plot.harv_swe <- plotfct_individual_ind("Harvested_V", df.forestStatl, "Sweden")
plot.incr_swe <- plotfct_individual_ind("i_Vm3", df.forestStatl, "Sweden")
plot.vol_swe <- plotfct_individual_ind("V", df.forestStatl, "Sweden")
plot.decid_swe <- plotfct_individual_ind("prc_V_deciduous", df.forestStatl, "Sweden")

plot.forestInd_swe <- egg::ggarrange(plot.harv_swe ,  plot.incr_swe, plot.vol_swe, plot.decid_swe, nrow = 4, ncol=1)

ggsave(plot = plot.forestInd_swe, paste0(outp_path,"plot.forestInd_swe.jpg"), width=7.5, height=10  ) 


# ------------
# call the function for Germany
# ------------
plot.harv_ger <- plotfct_individual_ind("Harvested_V", df.forestStatl, "Germany")
plot.incr_ger <- plotfct_individual_ind("i_Vm3", df.forestStatl, "Germany")
plot.vol_ger <- plotfct_individual_ind("V", df.forestStatl, "Germany")
plot.decid_ger <- plotfct_individual_ind("prc_V_deciduous", df.forestStatl, "Germany")

plot.forestInd_ger <- egg::ggarrange(plot.harv_ger ,  plot.incr_ger, plot.vol_ger, plot.decid_ger, nrow = 4, ncol=1)

ggsave(plot = plot.forestInd_ger, paste0(outp_path,"plot.forestInd_ger.jpg"), width=7.5, height=10  ) 



rm(list = ls(pattern = "plot"))



