#####
#
# "Climate change mitigation targets compromise forest ecosystem services and biodiversity"
# Supporting figures for supplementary info
# 2022-03-15
#
#####


# Bottom-up & Top-down analysis
# - Differemce between demand and optimized harvests
# - For the: three assortments, CC scenarios, optimization and countries

# Represented countries:
# - Finland
# - Germany
# - Norway



### load libraries
library(dplyr)
library(ggplot2)
library(tidyr)
library(ggpubr)




########################################################################################
# BOTTOM-UP - timely difference between Harvest and Demand by Assortment
########################################################################################


# -----------
# GLOBIOM Demands - over time
# -----------

gl_national_sort_timely <- df.gl_national_all %>% 
  select(-c("globiom","tot_demand")) %>% 
  # same name for assortments for merge the data later
  rename(Sawlog = GSawlog_uB,
         PulpFuel = GPulpFuel_uB,
         Residues = GResidues) %>% 
  gather("sort","demand", 2:4) 


# -----------
# Combine harvest and globiom data
# ----------- 

diff_gv1 <- harvest_sort_timely_gv1 %>% 
  # merge the globiom demands
  left_join(gl_national_sort_timely, by = c("year", "scenario","sort", "country")) %>% 
  # Difference in percent
  mutate(Diff = (harvest - demand) ) 



# -----------
# Plot it
# -----------


# change factor level for plotting
diff_gv1 <- diff_gv1 %>% 
  mutate(sort_plot = ifelse(sort %in% "Sawlog", "Sawlogs",
                            ifelse(sort %in% "PulpFuel", "Pulp- & Fuelwood", "Residues"))) %>% 
  mutate(sort_plot = factor(sort_plot, levels = c("Sawlogs", "Pulp- & Fuelwood", "Residues"))) %>% 
  mutate(policy_plot = ifelse(policy %in% "BAU", "NFS",
                              ifelse(policy %in% "Biodiv", "BDS", "BES"))) %>% 
  mutate(policy_plot = factor(policy_plot, levels = c("NFS", "BDS", "BES")))


plot.DiffHarvestDemandYearFkt <- function(data, COUNTRY, glVersion){
 
  if (COUNTRY == "Finland"){
    TITLE <- COUNTRY
  } else if (COUNTRY == "Germany"){
    TITLE <- "Germany (Bavaria)"
  } else if (COUNTRY == "Norway"){
    TITLE <- COUNTRY
  } else if (COUNTRY == "Sweden"){
    TITLE <- COUNTRY
  } 
  
  # adapt policy scenario name for plotting
  if(is.null(glVersion)){
    
    APPROACH <- "Bottom-up"
    
  } else {
    
    APPROACH <- "Top-down"
  } 
  
  # subset for country
  subData <- data %>% filter(country %in% COUNTRY)
  
  # min max year
  minYear <- min(subData$year)
  maxYear <- max(subData$year)
  
  plot <- subData %>% 
    ggplot(aes(year, Diff)) +
    
    geom_hline(yintercept=0) +
    geom_line( aes(color = policy_plot, linetype = scenario)) +
   
    # theme_light() +
    theme_bw()+
    theme(axis.text.x = element_text(angle = 90),
          legend.position="right",
          axis.title.x=element_blank(),
          #legend.title=element_blank(),
          #panel.grid.major = element_blank()
          panel.grid.minor = element_blank()
          ) +
    scale_linetype_manual("Mitigation target",values=c("solid", "dashed"), labels = c("1p5 (RCP1.9)" , "NDC (RCP4.5)") )+ # "dotted",
    scale_color_brewer("Policy",palette="Set1") +
    
    scale_x_continuous(breaks=c(seq(minYear,maxYear, by = 10) ))  +
    expand_limits(x = c(minYear, maxYear)) +
    
    facet_grid( .~sort_plot)+
    
    ylab(expression(Demand~achievement~"["~Mm^{3}~year^{-1}~"]")) +
    labs(title = paste(APPROACH)) # , TITLE
  plot
   
}


plot.diff_fin_gv1 <- plot.DiffHarvestDemandYearFkt(diff_gv1, "Finland", glVersion = NULL)
plot.diff_ger_gv1 <- plot.DiffHarvestDemandYearFkt(diff_gv1, "Germany", glVersion =NULL)
plot.diff_nor_gv1 <- plot.DiffHarvestDemandYearFkt(diff_gv1, "Norway", glVersion = NULL)
plot.diff_swe_gv1 <- plot.DiffHarvestDemandYearFkt(diff_gv1, "Sweden", glVersion = NULL)


ggsave(plot = plot.diff_fin_gv1, paste0(outp_path,"SI_diff_sort_fin_GV1.jpg"), width=7.5, height=3.5)
ggsave(plot = plot.diff_ger_gv1, paste0(outp_path,"SI_diff_sort_ger_GV1.jpg"), width=7.5, height=3.5)
ggsave(plot = plot.diff_nor_gv1, paste0(outp_path,"SI_diff_sort_nor_GV1.jpg"), width=7.5, height=3.5)
ggsave(plot = plot.diff_swe_gv1, paste0(outp_path,"SI_diff_sort_swe_GV1.jpg"), width=7.5, height=3.5)

rm(plot.diff_fin_gv1, plot.diff_ger_gv1, plot.diff_nor_gv1)
rm(diff_gv1)




########################################################################################
# TOP-DOWN - timely difference between Harvest and Demand by Assortment
########################################################################################



# -----------
# Combine harvest and globiom data
# ----------- 

diff_gv2 <- harvest_sort_timely_gv2 %>% 
  # merge the globiom demands
  left_join(gl_national_sort_timely, by = c("year", "scenario","sort", "country")) %>% 
  # Difference in percent
  mutate(Diff = (harvest - demand) ) 


# change factor level for plotting
diff_gv2 <- diff_gv2 %>% 
  mutate(sort_plot = ifelse(sort %in% "Sawlog", "Sawlogs",
                            ifelse(sort %in% "PulpFuel", "Pulp- & Fuelwood", "Residues"))) %>% 
  mutate(sort_plot = factor(sort_plot, levels = c("Sawlogs", "Pulp- & Fuelwood", "Residues"))) %>% 
  mutate(policy_plot = ifelse(policy %in% "BAU", "NFS",
                              ifelse(policy %in% "Biodiv", "BDS", "BES"))) %>% 
  mutate(policy_plot = factor(policy_plot, levels = c("NFS", "BDS", "BES")))


# -----------
# Plot it
# -----------

plot.diff_fin_gv2 <- plot.DiffHarvestDemandYearFkt(diff_gv2, "Finland", glVersion = "v2")
plot.diff_ger_gv2 <- plot.DiffHarvestDemandYearFkt(diff_gv2, "Germany", glVersion = "v2")
plot.diff_nor_gv2 <- plot.DiffHarvestDemandYearFkt(diff_gv2, "Norway", glVersion = "v2")
plot.diff_swe_gv2 <- plot.DiffHarvestDemandYearFkt(diff_gv2, "Sweden", glVersion = "v2")

ggsave(plot = plot.diff_fin_gv2, paste0(outp_path,"SI_diff_sort_fin_GV2.jpg"), width=7.5, height=3.5)
ggsave(plot = plot.diff_ger_gv2, paste0(outp_path,"SI_diff_sort_ger_GV2.jpg"), width=7.5, height=3.5)
ggsave(plot = plot.diff_nor_gv2, paste0(outp_path,"SI_diff_sort_nor_GV2.jpg"), width=7.5, height=3.5)
ggsave(plot = plot.diff_swe_gv2, paste0(outp_path,"SI_diff_sort_swe_GV2.jpg"), width=7.5, height=3.5)


rm(plot.diff_fin_gv2, plot.diff_ger_gv2, plot.diff_nor_gv2)
rm(diff_gv2)





########################################################################################
# BOTTOM-up - optimal management programm
########################################################################################


df.regime <- regime_share_all %>% 
  mutate(policy_plot = ifelse(policy %in% "BAU", "NFS",
                              ifelse(policy %in% "Biodiv", "BDS", "BES"))) %>% 
  mutate(policy_plot = factor(policy_plot, levels = c("NFS", "BDS", "BES"))) %>% 
  mutate(regime_6class = factor(regime_6class, levels = c( "I-BAU", "BAU", "E-BAU", "ACC",  "CCF","SA" ))) 



plot.RegimeShareFkt <- function(data, COUNTRY, glVersion){
  
  # adapt policy scenario name for plotting
  if(glVersion == "v1"){
    
    subData <- data %>% filter(country %in% COUNTRY & OptApproach %in% "v1")
    APPROACH <- "Bottom-up"
    
  } else {
    
    subData <- data %>% filter(country %in% COUNTRY & OptApproach %in% "v2")
    APPROACH <- "Top-down"
  } 
  
  # subset for country
  
  plot <- subData %>% 
    ggplot(aes(x=globiom, y=prc_share) ) + # , label = prc_share
    geom_bar(aes(fill=regime_6class), position="stack", stat="identity" ) +
    #geom_text(aes(group = regime_6class),size = 2.5, position = position_stack(vjust = 0.5), colour = "darkslategrey") +
    theme_minimal() +
    facet_grid(. ~ policy_plot) +
    ylab("share of regime class [%]") +
    theme(axis.text.x = element_text(angle = 45, vjust = 1, hjust=1),
          axis.title.x=element_blank(),
          legend.title = element_blank()) +
    #scale_fill_viridis_d() 
    scale_fill_brewer(palette="Pastel1", labels = c("Intensify BAU",
                                                    "Business-As-Usual",
                                                    "Extensify BAU",
                                                    "Adaption to CC",
                                                    "Continuous cover",
                                                    "Set aside" )) +
    labs(title = paste(APPROACH)) # , TITLE
  plot
  
}




plot.regime_fin_gv1 <- plot.RegimeShareFkt(df.regime, "Finland", "v1")
plot.regime_fin_gv2 <- plot.RegimeShareFkt(df.regime, "Finland", "v2")
ggsave(plot = plot.regime_fin_gv1, paste0(outp_path,"SI_regime_fin_gv1.jpg"), width=6, height=3.5)
ggsave(plot = plot.regime_fin_gv2, paste0(outp_path,"SI_regime_fin_gv2.jpg"), width=6, height=3.5)

plot.regime_ger_gv1 <- plot.RegimeShareFkt(df.regime, "Germany", "v1")
plot.regime_ger_gv2 <- plot.RegimeShareFkt(df.regime, "Germany", "v2")
ggsave(plot = plot.regime_ger_gv1, paste0(outp_path,"SI_regime_ger_gv1.jpg"), width=6, height=3.5)
ggsave(plot = plot.regime_ger_gv2, paste0(outp_path,"SI_regime_ger_gv2.jpg"), width=6, height=3.5)

plot.regime_swe_gv1 <- plot.RegimeShareFkt(df.regime, "Sweden", "v1")
plot.regime_swe_gv2 <- plot.RegimeShareFkt(df.regime, "Sweden", "v2")
ggsave(plot = plot.regime_swe_gv1, paste0(outp_path,"SI_regime_swe_gv1.jpg"), width=6, height=3.5)
ggsave(plot = plot.regime_swe_gv2, paste0(outp_path,"SI_regime_swe_gv2.jpg"), width=6, height=3.5)

plot.regime_nor_gv1 <- plot.RegimeShareFkt(df.regime, "Norway", "v1")
plot.regime_nor_gv2 <- plot.RegimeShareFkt(df.regime, "Norway", "v2")
ggsave(plot = plot.regime_nor_gv1, paste0(outp_path,"SI_regime_nor_gv1.jpg"), width=6, height=3.5)
ggsave(plot = plot.regime_nor_gv2, paste0(outp_path,"SI_regime_nor_gv2.jpg"), width=6, height=3.5)


rm(list = ls()[grep("plot", ls())])








