# !/usr/bin/env python
# Creates 3 solubility plots provided by Jamie Connolly and 3 plots for analytical functions used
# written by Antoine Rozel, modified by Charitra Jain


# This script uses colormaps from Scientific Colour Maps 7.0
# Please cite as:
# Crameri, F.: Scientific colour maps, https://doi.org/10.5281/zenodo.5501399, https://doi.org/10.5281/zenodo.5501399, 2021
# Crameri, F., Shephard, G. E., and Heron, P. J.: The misuse of colour in science communication, Nature Communications, 11, 5444,
# https://doi.org/10.1038/s41467-020-19160-7, 2020.
# Python wrapper around Fabio Crameri's perceptually uniform colormaps can be installed from https://pypi.org/project/cmcrameri/

# Other python packages required: numpy, matplotlib, scipy, os

import numpy as np
import matplotlib.pyplot as plt
from matplotlib.colors import ListedColormap, LinearSegmentedColormap
from scipy.stats import kde
from cmcrameri import cm
import os

import matplotlib as mpl
mpl.rcParams['font.family'] = "sans-serif"
mpl.rcParams['font.sans-serif'] = "Arial"
mpl.rcParams['lines.linewidth'] = 0.5
mpl.rcParams['font.size'] = 10
mpl.rcParams['axes.linewidth'] = 1
mpl.rcParams['axes.titlesize'] = 10
mpl.rcParams['legend.fontsize'] = 10
mpl.rcParams['axes.titleweight'] = "bold"


local_system=os.getlogin()
here = os.getcwd()

# Create a figure with 6 plot areas
fig, axes = plt.subplots(ncols=3, nrows=2, figsize=(9, 6))
fig.subplots_adjust(hspace=0.4, wspace=0.3)
plt.subplots_adjust(left=0.05, right=0.9, top=0.9, bottom=0.1)

n1=500
n2=100


# Harzburgite (stag) -----------------------------

temperature = []
pressure = []
solubility = []

file='data/HarzFit.dat'
i=0
j=0
f = open(file, 'r')
lines = f.readlines()
f.close
for line in lines:
    p = line.split()
    temperature.append(float(p[0]))
    pressure.append(float(p[1]))
    solubility.append(float(p[2]))

temperaturev = np.array(temperature)
pressurev = np.array(pressure)
solubilityv = np.array(solubility)

xi = temperaturev.reshape(n1,n2)
yi = pressurev.reshape(n1,n2)
zi = solubilityv.reshape(n1,n2)


# cmap = plt.get_cmap('PiYG')
cmap = cm.lapaz_r

axes[i,j].set_title('Harzburgite (this study)')
im = axes[i,j].pcolormesh(xi,yi,zi,cmap=cmap,vmin=0,vmax=11, rasterized=True)
xticks=[500,1000,1500,2000,2500]
axes[i,j].set_xticks(xticks)
axes[i,j].set_xlabel("Temperature (K)")
axes[i,j].set_ylabel("Pressure (GPa)")
axes[i,j].set_ylim(0,25)
axes[i,j].set_xlim(300,2500)
axes[i,j].invert_yaxis()
axes[i,j].set_aspect(2200/25)

# ----------------------------------------------------

# Basalt (stag)
temperature = []
pressure = []
solubility = []

file='data/BasaltFit.dat'
i=0
j=1
f = open(file, 'r')
lines = f.readlines()
f.close
for line in lines:
    p = line.split()
    temperature.append(float(p[0]))
    pressure.append(float(p[1]))
    solubility.append(float(p[2]))

temperaturev = np.array(temperature)
pressurev = np.array(pressure)
solubilityv = np.array(solubility)

xi = temperaturev.reshape(n1,n2)
yi = pressurev.reshape(n1,n2)
zi = solubilityv.reshape(n1,n2)

# cmap = plt.get_cmap('PiYG')
cmap = cm.lapaz_r

axes[i,j].set_title('Basalt (this study)')
im = axes[i,j].pcolormesh(xi,yi,zi,cmap=cmap,vmin=0,vmax=11, rasterized=True)
xticks=[500,1000,1500,2000,2500]
axes[i,j].set_xticks(xticks)
axes[i,j].set_xlabel("Temperature (K)")
axes[i,j].set_ylabel("Pressure (GPa)")
axes[i,j].set_ylim(0,25)
axes[i,j].set_xlim(300,2500)
axes[i,j].invert_yaxis()
axes[i,j].set_aspect(2200/25)

# ----------------------------------------------------

# TTG (stag)
temperature = []
pressure = []
solubility = []

file='data/TTGFit.dat'
i=0
j=2
f = open(file, 'r')
lines = f.readlines()
f.close
for line in lines:
    p = line.split()
    temperature.append(float(p[0]))
    pressure.append(float(p[1]))
    solubility.append(float(p[2]))

temperaturev = np.array(temperature)
pressurev = np.array(pressure)
solubilityv = np.array(solubility)

xi = temperaturev.reshape(n1,n2)
yi = pressurev.reshape(n1,n2)
zi = solubilityv.reshape(n1,n2)

# cmap = plt.get_cmap('PiYG')
cmap = cm.lapaz_r

axes[i,j].set_title('TTG (this study)')
im = axes[i,j].pcolormesh(xi,yi,zi,cmap=cmap,vmin=0,vmax=11, rasterized=True)
xticks=[500,1000,1500,2000,2500]
axes[i,j].set_xticks(xticks)
axes[i,j].set_xlabel("Temperature (K)")
axes[i,j].set_ylabel("Pressure (GPa)")
axes[i,j].set_ylim(0,25)
axes[i,j].set_xlim(300,2500)
axes[i,j].invert_yaxis()
axes[i,j].set_aspect(2200/25)

# Harzburgite (Connolly model) -----------------------------

temperature = []
pressure = []
solubility = []

file='data/Harz.dat'
i=1
j=0
f = open(file, 'r')
lines = f.readlines()
f.close
for line in lines:
    p = line.split()
    temperature.append(float(p[0]))
    pressure.append(float(p[1]))
    solubility.append(float(p[2]))

temperaturev = np.array(temperature)
pressurev = np.array(pressure)
solubilityv = np.array(solubility)

xi = temperaturev.reshape(40,38)
yi = pressurev.reshape(40,38)/10000.
zi = solubilityv.reshape(40,38)

# cmap = plt.get_cmap('PiYG')
cmap = cm.lapaz_r

axes[i,j].set_title('Harzburgite (petrological model)')
im = axes[i,j].pcolormesh(xi,yi,zi,cmap=cmap,vmin=0,vmax=11, rasterized=True)
xticks=[473,1000,1500,2000]
axes[i,j].set_xlim(450,2000)
axes[i,j].set_xticks(xticks)
axes[i,j].set_xlabel("Temperature (K)")
axes[i,j].set_ylabel("Pressure (GPa)")
axes[i,j].set_ylim(0,25)
axes[i,j].invert_yaxis()
axes[i,j].set_aspect(2050/25)

# ----------------------------------------------------

# Basalt (Connolly model)
temperature = []
pressure = []
solubility = []

file='data/Morb.dat'
i=1
j=1
f = open(file, 'r')
lines = f.readlines()
f.close
for line in lines:
    p = line.split()
    temperature.append(float(p[0]))
    pressure.append(float(p[1]))
    solubility.append(float(p[2]))

temperaturev = np.array(temperature)
pressurev = np.array(pressure)
solubilityv = np.array(solubility)

xi = temperaturev.reshape(40,38)
yi = pressurev.reshape(40,38)/10000.
zi = solubilityv.reshape(40,38)

#cmap = plt.get_cmap('PiYG')
cmap = cm.lapaz_r

axes[i,j].set_title('Basalt (petrological model)')
im = axes[i,j].pcolormesh(xi,yi,zi,cmap=cmap,vmin=0,vmax=11, rasterized=True)
xticks=[473,1000,1500,2000]
axes[i,j].set_xlim(450,2000)
axes[i,j].set_xticks(xticks)
axes[i,j].set_xlabel("Temperature (K)")
axes[i,j].set_ylabel("Pressure (GPa)")
axes[i,j].set_ylim(0,25)
axes[i,j].invert_yaxis()
axes[i,j].set_aspect(2050/25)

# ----------------------------------------------------

# TTG (Connolly model)
temperature = []
pressure = []
solubility = []

file='data/TTG.dat'
i=1
j=2
f = open(file, 'r')
lines = f.readlines()
f.close
for line in lines:
    p = line.split()
    temperature.append(float(p[0]))
    pressure.append(float(p[1]))
    solubility.append(float(p[2]))

temperaturev = np.array(temperature)
pressurev = np.array(pressure)
solubilityv = np.array(solubility)

xi = temperaturev.reshape(40,38)
yi = pressurev.reshape(40,38)/10000.
zi = solubilityv.reshape(40,38)

#cmap = plt.get_cmap('PiYG')
cmap = cm.lapaz_r

axes[i,j].set_title('TTG (petrological model)')
im = axes[i,j].pcolormesh(xi,yi,zi,cmap=cmap,vmin=0,vmax=11, rasterized=True)
xticks=[473,1000,1500,2000]
axes[i,j].set_xlim(450,2000)
axes[i,j].set_xticks(xticks)
axes[i,j].set_xlabel("Temperature (K)")
axes[i,j].set_ylabel("Pressure (GPa)")
axes[i,j].set_ylim(0,25)
axes[i,j].invert_yaxis()
axes[i,j].set_aspect(2050/25)

# x-y coordinates, thickness, length
cax = plt.axes([0.92, 0.1, 0.02, 0.8])
cbar = fig.colorbar(im,ax=axes[i,j],cax=cax)
cbar.set_label('Water Saturation (weight %)', rotation=270, labelpad=10)

fig.savefig('fig1.pdf', format='pdf')
