# -*- coding: utf-8 -*-
#
# Configuration file for the Sphinx documentation builder.
#
# This file does only contain a selection of the most common options. For a
# full list see the documentation:
# http://www.sphinx-doc.org/en/master/config

import datetime

try:
    from asreview import __version__ as asreview_verion
except Exception:
    asreview_verion = ""

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import sys
sys.path.insert(0, os.path.abspath(os.path.join('..', '..')))
sys.path.insert(0, os.path.abspath('..'))


# -- Mock
autodoc_mock_imports = [
    "numpy",
    "modAL",
    "modAL.models",
    "modAL.utils.data",
    "modAL.utils.selection",
    "rispy",
    "pandas",
    "tensorflow",
    "tensorflow.keras",
    "tensorflow.keras.wrappers.scikit_learn",
    "tensorflow.keras.models",
    "tensorflow.keras.models.layers",
    "tensorflow.keras.optimizers",
    "tensorflow.keras.constraints",
    "sklearn",
    "sklearn.naive_bayes",
    "sklearn.svm",
    "sklearn.base",
    "sklearn.exceptions",
    "scipy",
    "fuzzywuzzy",
    "dill",
    "PyInquirer",
    "gensim",
    "gensim.utils"
    "gensim.models.doc2vec",
    "sentence_transformers",
    "sentence_transformers.SentenceTransformer",
]


# -- Project information -----------------------------------------------------

# add current year
year = datetime.datetime.now().year

project = 'ASReview LAB'
copyright = '{}, ASReview LAB developers'.format(year)
author = 'ASReview LAB developers, Utrecht University'

# The short X.Y version
version = asreview_verion
# The full version, including alpha/beta/rc tags
release = asreview_verion


# -- General configuration ---------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.intersphinx',
    'sphinx.ext.autosummary',
    'sphinx.ext.viewcode',
    'sphinx.ext.napoleon',
    'sphinx.ext.autosectionlabel',
    'sphinx_reredirects',
    'nbsphinx',
]
autosectionlabel_prefix_document = True

# generate autosummary even if no references
autosummary_generate = True

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst']
source_suffix = ['.rst']

# The master toctree document.
master_doc = 'index'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
# language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ['build', '**.ipynb_checkpoints']

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = None


# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = "sphinx_rtd_theme"

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
# html_theme_options = {}

html_static_path = ['_static']


# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_css_files = ["css/asreviewtheme.css"]

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# The default sidebars (for documents that don't match any pattern) are
# defined by theme itself.  Builtin themes are using these templates by
# default: ``['localtoc.html', 'relations.html', 'sourcelink.html',
# 'searchbox.html']``.
#
# html_sidebars = {}


# -- Options for HTMLHelp output ---------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = 'ASReviewdoc'


# -- Options for LaTeX output ------------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',

    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',

    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',

    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, 'ASReview.tex', 'ASReview Software Documentation',
     author, 'manual'),
]


# -- Options for manual page output ------------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (master_doc, 'asreview', 'ASReview Software Documentation',
     [author], 1)
]


# -- Options for Texinfo output ----------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (master_doc, 'ASReview', 'ASReview Software Documentation',
     author, 'ASReview', 'ASReview Software Documentation.',
     'Miscellaneous'),
]


# -- Options for Epub output -------------------------------------------------

# Bibliographic Dublin Core info.
epub_title = project

# The unique identifier of the text. This can be a ISBN number
# or the project homepage.
#
# epub_identifier = ''

# A unique identification for the text.
#
# epub_uid = ''

# A list of files that should not be packed into the epub file.
epub_exclude_files = ['search.html']


# -- Extension configuration -------------------------------------------------

# -- Options for intersphinx extension ---------------------------------------

# Example configuration for intersphinx: refer to the Python standard library.
intersphinx_mapping = {
    'python': ('https://docs.python.org/3', None),
    'numpy': ('http://docs.scipy.org/doc/numpy', None),
    'pandas': ('https://pandas.pydata.org/docs/', None),
}

# -- Napoleon options --------------------------------------------------------

napoleon_google_docstring = False
napoleon_numpy_docstring = True
napoleon_include_private_with_doc = False
napoleon_include_special_with_doc = False
napoleon_use_admonition_for_examples = False
napoleon_use_admonition_for_notes = True
napoleon_use_admonition_for_references = True
napoleon_use_ivar = True
napoleon_use_param = True
napoleon_use_rtype = False

# -- Redirects ---------------------------------------------------------------

redirects = {
    "intro/zen": "https://asreview.ai/blog/the-zen-of-elas/",
    "intro/datasets": "../data.html",
    "intro/faq": "https://github.com/asreview/asreview/discussions",
    "intro/vocabulary": "../about.html",

    "lab/overview_lab": "../about.html",
    "lab/launch": "../start.html",
    "lab/oracle": "../about.html",
    "lab/exploration": "../about.html",
    "lab/simulation": "../simulation_overview.html",

    "features/settings": "../screening.html",
    "features/pre_screening": "../project_create.html",
    "features/screening": "../screening.html",
    "features/post_screening": "../progress.html",

    "extensions/overview_extensions": "../extensions_overview.html",
    "extensions/extension_covid19": "../extensions_overview.html",
    "extensions/extension_visualization": "../extensions_overview.html",
    "extensions/extension_wordcloud": "../extensions_overview.html",

    "API/extension_dev": "../extensions_dev.html",

    "guides/activelearning": "https://asreview.nl/blog/active-learning-explained/",
    "guides/simulation_study_results": "https://asreview.nl/research/",
    "guides/sim_overview": "../simulation_overview.html",
}
