# Contributing to ASReview
Hello dear contributor-to-be! :wave:

Awesome to see that you're considering to contribute to ASReview!
Below you will find some guidelines for your future contributions.

#### Feel free to propose changes of any kind!
Your ideas and input are very much appreciated.
From contributing to source code to improving readability of the documentation, all suggestions are welcome!

There are multiple ways to contribute:
- [Reporting bugs](#reporting-bugs) :bug: :ant: 🐞
- [Suggesting enhancements](#feature-request)
- [Contribute code](#contribute-code)
- [Contribute in discussions](#discussions)

##  Reporting Bugs
Found a glitch in the matrix?
Create [an issue](https://github.com/asreview/asreview/issues/new/choose)! Make sure to choose the Bug issue template.

## Feature request
Got a suggestion for enhancement of ASReview?
[File an issue](https://github.com/asreview/asreview/issues/new/choose) and use the Feature request template.

## Contribute code
Want to try to fix the bug you found?
Build your feature request yourself?
Brilliant! :heart_eyes:
You can submit your changes to ASReview [by creating a pull request](https://github.com/asreview/asreview/pull/new/master).

#### Unsure where to begin? Here are a few examples:  
- Improve the [documentation](https://asreview.readthedocs.io/en/latest/). :memo:
- Propose a fix to an existing issue. :warning:
  - See the [issue list here](https://github.com/asreview/asreview/issues).
- Add a new dataset to [our open dataset repository](https://github.com/asreview/systematic-review-datasets/pull/11)
  - See this [pull request](https://github.com/asreview/systematic-review-datasets/pull/11) for an example.

## Discussions
Got any questions for the ASReview community?
Or perhaps you know the answer to a question asked? 💡
Don't hesitate to post on the [discussion board](https://github.com/asreview/asreview/discussions).

## First timer?
Do you have little experience with contributing to open-source project and working with GitHub? :octocat: No worries! There are some amazing tutorials out there:

- [First timers only](https://www.firsttimersonly.com)
  - See the [first-contributions repo](https://github.com/firstcontributions/first-contributions) for a tutorial on how to contribute code.
- [How To Contribute To An Open Source Project on GitHub](https://egghead.io/courses/how-to-contribute-to-an-open-source-project-on-github).
- [Mastering Issues](https://guides.github.com/features/issues/) by GitHub.
- [About Pull Requests](https://help.github.com/en/github/collaborating-with-issues-and-pull-requests/about-pull-requests) by GitHub.

## Life after the pull request
Your pull request will be carefully reviewed by the maintainers.
They will get back at you as soon as possible and possibly start integrating your suggestions and/or contributions into the project.

## Need more information?
If you have any more questions, do not hesitate to send an e-mail to asreview@uu.nl.

Thanks again for your contribution, the ASReview team. :yellow_heart:
