import sys
import copy
import pyomo.environ as pyo
import numpy as np
from pyomo.opt import SolverFactory
import random
import json
import matplotlib.pyplot as plt
import time
from numpy import linalg as LNG 
import os
from classes.System import System
from classes.Model import PlatformModel, UserModel
from classes.Algorithm import Algorithm
from os import path 
from IPython import get_ipython
import re
from mpl_toolkits.axes_grid1 import make_axes_locatable
from matplotlib.ticker import (MultipleLocator, FormatStrFormatter,
                               AutoMinorLocator)


def draw_best_Baron_only_edge_cloud_profit(D):
    X=[x for x in range(50, 1050,50)]
    
    width = 0.1
    
    list_P_edge=[]
    list_P_cloud=[]
    list_P_dep1=[]
    list_best_P=[]
    list_Baron_P=[]
    input_file="ConfigFiles/system_file.json"
    for N in X:
        cloud=0
        edge_err=0
        dep1_err=0
        feasible_edge=0
        best_P=0
        Baron_err=0
        feasible_Baron=0
      
        for Ins in [1]:
            
            Path="output_4G/"+str(N)+"users/Ins"+str(Ins)
            best_P=np.load(Path+"/best_P.npy")
            P_cloud=np.load(Path + '/only_cloud_P.npy')
            cloud+=P_cloud
            P_dep1=np.load(Path + '/all_dep1_P.npy')
            dep1_err+=((best_P-P_dep1)*100)/best_P
            feasible=np.load(Path + '/only_edge_feasible.npy')
            # P=np.load(Path + '/only_edge_P.npy')
            # P_edge+=P
            # if feasible:
            #     feasible_edge+=1
           
           
           
            
            if path.isfile(Path+"/Baron_P.npy") and np.load(Path+"/Baron_P.npy")>0:
                P_Baron=np.load(Path+"/Baron_P.npy")
                Baron_err+=((best_P-P_Baron)*100)/best_P
                feasible_Baron+=1
             
        
        list_P_cloud.append(cloud)
        list_P_dep1.append(dep1_err)
        # if feasible_edge>0:
        #      list_P_edge.append(P_edge/feasible_edge)
        # else:
        #     list_P_edge.append(0)
        #list_best_P.append(best_P/10)
        if feasible_Baron>0:
            list_Baron_P.append(Baron_err/feasible_Baron)
          
    breakpoint()
    N=np.arange(len([x for x in X if x<400]))  
    # matplotlib.use('WebAgg')
    # import matplotlib.pyplot as plt1,mpld3
    get_ipython().run_line_magic('matplotlib', 'qt')
 
        #fig1 = plt.figure()
    fig = plt.figure()
    ax = plt.subplot(111)
    #ax.bar(N-0.1, list_P_cloud, width)
    ax.bar(N, list_P_dep1[:7], width,color='red')
   # ax.bar(N-0.1, list_P_edge, width)
    #ax.bar(N, list_best_P, width)
    ax.bar(N+0.1, list_Baron_P[:7], width)
    N=np.arange(len([x for x in X if x>=400]))
    ax.bar(N+7, list_P_dep1[7:], width, color='red')
    
    N=np.arange(len([x for x in X ])) 
    plt.xticks(N, [str(x) for x in X] )
    plt.xlabel("Number of users")
    plt.ylabel("Platform profit ratio (%)")
    plt.legend([ "All dep1",   "Baron"])
    plt.title("4G")
    plt.show()
    figure = plt.gcf()
    figure.set_size_inches(13, 4)
    plt.savefig('bestBarondep14G.pdf') 
    
    fig = plt.figure()
    ax = plt.subplot(111)
    ax.bar(N, list_P_cloud, width)
   
    
    plt.xticks(N, [str(x) for x in X] )
    plt.xlabel("Number of users")
    plt.ylabel("Platform profit")
   
    plt.yscale('symlog')
    plt.title("4G")
    plt.show()
    figure = plt.gcf()
    figure.set_size_inches(13, 4)
    plt.savefig('onlyCloudProfit4G.pdf') 
    
def draw_best_only_cloud_all_dep1_social_walfare(scenarios, main_senario):
    X=[x for x in range(50, 1050,50)]
    
    width = 0.2
    N_total=np.arange(start=0, stop=len(X)*2, step=2)
    diff=0
    get_ipython().run_line_magic('matplotlib', 'qt')
    fig = plt.figure()
    for scenario in scenarios:
        list_social_walefare_cloud=[]
        list_social_walefare_dep1=[]
        list_best_social_walefare=[]
        
        for N in X:
            social_walefare_dep1=0
            social_walefare_best=0
            social_walefare_cloud=0
            for Ins in [1,2,3,4,5,6,7,8,9,10]:
                
                Path="output_"+scenario+"/"+str(N)+"users/Ins"+str(Ins)
               
                social_walefare=np.load(Path + '/social_welfare_only_cloud.npy')
                social_walefare_cloud+=social_walefare
                social_walefare=np.load(Path + '/social_welfare_all_dep1.npy')
                social_walefare_dep1+=social_walefare
               
                social_welfare=np.load(Path + '/social_welfare.npy')
                social_walefare_best+=social_welfare
                
               
               
                 
            
            list_social_walefare_cloud.append(social_walefare_cloud/10)
            list_social_walefare_dep1.append(social_walefare_dep1/10)
            
            list_best_social_walefare.append(social_walefare_best/10)
            
    
        ax = plt.subplot(111)
        ax.bar(N_total+diff-0.4, list_social_walefare_cloud, width)
        ax.bar(N_total+diff-0.2, list_social_walefare_dep1, width)
       
        ax.bar(N_total+diff, list_best_social_walefare, width)
        diff+=0.7
    
    plt.xticks(N_total, [str(x) for x in X] )
    plt.xlabel("Number of users")
    plt.ylabel("Social welfare")
    plt.legend(["All dep2 only cloud high energy", "All dep1 high energy", "Proposed approach high energy","All dep2 only cloud low energy", "All dep1 low energy", "Proposed approach low energy"],fontsize=7)
    plt.yscale('symlog')
    plt.title(main_senario)
    plt.show()
    figure = plt.gcf()
    figure.set_size_inches(13, 5)
    plt.savefig('bestOnlyCloudDep1SocialWalfare_'+main_senario+'.pdf') 
    
def parse_Baron_log(Path):
   
    input_file=Path+"/Baron_log"
    important = []
    keep_phrases = ["Lower bound"]
    
    with open(input_file, "r") as f:
        f = f.read()
   
    x=f.split("Upper bound")[1]
    y=x.split("\n")
    i=1
    time_stamps=[]
    objs=[]
    upper_bound=[]
    while len(y[i])>0:
        num=y[i].split()
        if num[0].startswith("*"):
            time_idx=3
        else:
            time_idx=2
        if  bool(re.search(r'\d', num[time_idx])):
            time_stamps.append(float(num[time_idx]))
            if float(num[time_idx+1])<0:
                #objs.append(0)
               
                objs.append(float(num[time_idx+1]))
            else:
                objs.append(float(num[time_idx+1]))
            upper_bound.append(float(num[time_idx+2]))
        i=i+1
    return time_stamps, objs, upper_bound

def draw_Baron_proposed_compare():  
     # feasible_Ins=[]
     # for N in [ 50, 100,150,200,250, 300,350, 400,450]:

     #     if np.load(Path+"/Baron_P.npy")>0
     for N in [50, 100,150,200,250, 300,350, 400, 450]:
        ave_best_P=0 
        ave_exce_time=0
        
        list_Baron_time_stamps=[]
        list_Baron_objs=[]
        list_Baron_upper_bound=[]
        max_time=0
        Len=0
        
        for Ins in [2]:
            Path="output_mixed_high_E/" + str(N) + "users/Ins"+str(Ins)
            best_P=np.load(Path+"/best_P.npy")
            ave_best_P+=best_P
            exce_time=np.load(Path+"/exec_time.npy")
            ave_exce_time+=exce_time
            n_c=np.load(Path+"/best_n_c.npy")
            n_e=np.load(Path+"/best_n_e.npy")

            Baron_time_stamps, Baron_objs, Baron_upper_bound=parse_Baron_log(Path)
           
        draw_results(Baron_time_stamps, Baron_objs,Baron_upper_bound, ave_best_P, ave_exce_time,N)
        

def draw_dep(scenarios, main_scenario):
    X=[x for x in range(50, 1050,50)]
    
    width = 0.2
    N_total=np.arange(start=0, stop=len(X)*1.5, step=1.5)
    diff=0
    get_ipython().run_line_magic('matplotlib', 'qt')
    fig = plt.figure()
    for scenario in scenarios:
        list_ave_dep0=[]
        list_ave_dep1=[]
        list_ave_Baron_dep0=[]
        list_ave_Baron_dep1=[]
        for N in X:
            sum_dep0=0
            sum_dep1=0
            sum_Baron_dep0=0
            sum_Baron_dep1=0
            
           
            feasible_Baron=0
            for Ins in [1]:
                Path="output_"+scenario+"/" + str(N) + "users/Ins"+str(Ins)
                best_x=np.load(Path+"/best_x.npy")
                sum_dep0+=sum(best_x[:,0])
                sum_dep1+=sum(best_x[:,1])
                if path.isfile(Path+"/Baron_P.npy") and np.load(Path+"/Baron_P.npy")>0:
                    Baron_x=np.load(Path+"/Baron_x.npy")
                    sum_Baron_dep0+=sum(Baron_x[:,0])
                    sum_Baron_dep1+=sum(Baron_x[:,1])
                    feasible_Baron+=1
               
        
            list_ave_dep0.append(sum_dep0/1)
            list_ave_dep1.append(sum_dep1/1)
            if feasible_Baron>0:
                list_ave_Baron_dep0.append(sum_Baron_dep0/feasible_Baron)
                list_ave_Baron_dep1.append(sum_Baron_dep1/feasible_Baron)
            else:
                list_ave_Baron_dep0.append(0)
                list_ave_Baron_dep1.append(0)
        
       # N=np.arange(len([x for x in X if x<400]))#np.arange(len(X))  
       
        # matplotlib.use('WebAgg')
        # import matplotlib.pyplot as plt1,mpld3
        
       
        plt.bar(N_total+diff-0.4, list_ave_dep0, width)
        plt.bar(N_total+diff-0.2, list_ave_dep1, width)
        diff+=0.5
    # plt.bar(N, list_ave_Baron_dep0[:7], width, color='green')
    # plt.bar(N+0.2, list_ave_Baron_dep1[:7], width, color='blue')
    # N=np.arange(len([x for x in X if x>=400]))
    # plt.bar(N+7-0.1, list_ave_dep0[7:], width, color='cyan')
    # plt.bar(N+7+0.1, list_ave_dep1[7:], width, color='orange')
    # plt.bar(N, list_ave_Baron_dep0[8:], width, color='green')
    # plt.bar(N+0.2, list_ave_Baron_dep1[8:], width, color='blue')
    
     
    plt.xticks(N_total, [str(x) for x in X] )
    plt.xlabel("Total number of users")
    plt.ylabel("Number of participants")
    plt.legend(["First deployment high energy", "Second deployment high energy", "First deployment low energy", "Second deployment low energy"])
    plt.title(main_scenario)
    plt.show()
    figure = plt.gcf()
    figure.set_size_inches(13, 4)
    plt.savefig('deployments_'+main_scenario+'.pdf') 
    
#  function to compare the profit and execution time of proposed approach vs BARON
def draw_results(Baron_time_stamps, Baron_objs,Baron_upper_bound, best_P, exce_time,N):
    
    plt.figure()
    best_P_list=[0,best_P]
    exce_time_list=[0,exce_time]
   
   
    xdomain = Baron_time_stamps

    axMain = plt.subplot(111)
    markers_on=  list(i for i in range(len(Baron_objs)))
    axMain.plot(Baron_time_stamps,Baron_objs,'--r', markevery=markers_on,label="Baron lower bound" )
    markers_on=  list(i for i in range(len(Baron_upper_bound)))
    axMain.plot(Baron_time_stamps,Baron_upper_bound,'--b', markevery=markers_on,label="Baron upper bound" )
    markers_on=  list(i for i in range(len(best_P_list)))
    axMain.plot(exce_time_list,best_P_list,'-gD', markevery=markers_on,label="Proposed approach" )
    axMain.set_yscale('symlog')
    axMain.set_xscale('symlog')
    axMain.set_ylim((-10000000000, -100))
    
    # axMain.spines['top'].set_visible(False)
    # axMain.xaxis.set_ticks_position('bottom')
    divider = make_axes_locatable(axMain)
    axLin = divider.append_axes("top", size=2.0, pad=0.02, sharex=axMain)
    markers_on=  list(i for i in range(len(Baron_objs)))
    axLin.plot(Baron_time_stamps,Baron_objs,'--r', markevery=markers_on,label="Baron lower bound" )
    markers_on=  list(i for i in range(len(Baron_upper_bound)))
    axLin.plot(Baron_time_stamps,Baron_upper_bound,'--b', markevery=markers_on,label="Baron upper bound" )
    markers_on=  list(i for i in range(len(best_P_list)))
    axLin.plot(exce_time_list,best_P_list,'-gD', markevery=markers_on,label="Proposed approach" )
   
    axLin.set_xscale('linear')
    axLin.set_ylim((0, max([max(Baron_objs),max(Baron_upper_bound),max(best_P_list)])+100))
    # axLin.spines['bottom'].set_visible(False)
    # axLin.xaxis.set_ticks_position('top')
    
    # axLin.yaxis.set_major_locator(matplotlib.ticker.LogLocator(subs=(1,2,)))
    # axLin.yaxis.set_major_formatter(matplotlib.ticker.ScalarFormatter())
    # axLin.yaxis.set_minor_formatter(matplotlib.ticker.NullFormatter())
   
    plt.setp(axLin.get_xticklabels(), visible=False)
  
    axMain.set_yticks([-10000000000, -100000, -1000])
   
    plt.title(str(N)+ " users")
    plt.xlabel("Execution time (s)", fontsize=10)
    plt.ylabel("Platform profit ($/h)", fontsize=10)
   # axLin.xaxis.set_visible(False)
   # axMain.xaxis.set_visible(True)
    axMain.set_xlabel("Execution time (s)")
    
    
    axLin.get_xaxis().set_visible(False)
    
   
    
    
    plt.legend()
    plt.show()
    
    plt.savefig('Baron_proposed_'+str(N)+'users_4G_high_E.pdf')

def draw_bar_time_profit():
    
   
    list_ave_best_P=[]
    list_ave_exce_time=[]
    X=[x for x in range(50, 1050,50)]#[ 100, 200,300,400,500, 600,700, 800, 900, 1000]
    for N in X:
        ave_best_P=0 
        ave_exce_time=0
        
       
        for Ins in [1,2,3,4,5,6,7,8,9,10]:
            Path="output_mixed_high_E/" + str(N) + "users/Ins"+str(Ins)
            best_P=np.load(Path+"/best_P.npy")
            ave_best_P+=best_P
            exce_time=np.load(Path+"/exec_time.npy")
            ave_exce_time+=exce_time
            
          
        ave_best_P=ave_best_P/10
        ave_exce_time=ave_exce_time/10
        list_ave_best_P.append(ave_best_P)
        list_ave_exce_time.append(ave_exce_time)
    # create figure and axis objects with subplots()
    data=[list_ave_best_P,list_ave_exce_time]
    
    import plotly.graph_objects as go
   
    fig = go.Figure(
        data=[
            go.Bar(name='Platform profit', x=X, y=data[0], yaxis='y', offsetgroup=1),
            go.Bar(name='Execution time', x=X, y=data[1], yaxis='y2', offsetgroup=2)
        ],
        layout={
            'yaxis': {'title': 'Average platform profit ($)'},
            'yaxis2': {'title': 'Average execution time (s)', 'overlaying': 'y', 'side': 'right'},
            'xaxis': {'title': 'Number of users','type': 'category' }
            
        }
    )
    
    # Change the bar mode
    fig.update_layout(autosize=False, width=1000, height=500,barmode='group')
    
    fig.show()
    fig.write_image("bar_mixed_high_E.pdf")
    
def draw_resource_numbers(scenarios, main_scenario):
    X=[x for x in range(50, 1050,50)]
   
    width = 0.2
    N_total=np.arange(start=0, stop=len(X)*1.5, step=1.5) 
    diff=0
    get_ipython().run_line_magic('matplotlib', 'qt')
    fig = plt.figure()
    for scenario in scenarios: 
        N_e=[]
        list_ave_best_n_c=[]
        list_ave_best_n_e=[]
        
        for N in X:
            ave_best_n_c=0
            ave_best_n_e=0
            
            for Ins in [1]:
                
                Path="output_"+scenario+"/" + str(N) + "users/Ins"+str(Ins)
                new_file_name="output_"+scenario+"/"+str(N)+"users/Ins"+str(Ins)+"/system_file.json"
                D=2
                S=System(N, D,new_file_name)
                N_e.append(S.N_e)
                best_n_c=np.load(Path+"/best_n_c.npy")
                ave_best_n_c+=best_n_c
                best_n_e=np.load(Path+"/best_n_e.npy")
                ave_best_n_e+=best_n_e
                
        
            list_ave_best_n_c.append(ave_best_n_c)
            list_ave_best_n_e.append(ave_best_n_e)
           
        
       
        plt.bar(N_total+diff-0.3, list_ave_best_n_c, width,zorder=5)
        plt.bar(N_total+diff-0.1, list_ave_best_n_e, width,zorder=0)
        diff+=0.5
    
    # N=np.arange(len(X)) 
    plt.xticks(N_total, [str(x) for x in X] )
    plt.scatter(N_total-0.1, N_e,  marker=('*'),zorder=10)
    plt.xlabel("Number of users")
    plt.ylabel("Number of resources")
    #plt.legend(["Cloud VMs by proposed approach", "Edge VMs by proposed approach", "Cloud VMs by Baron", "Edge VMs by Baron"])
    plt.legend([ "Max number of edge servers","Cloud VMs high energy", "Edge servers high energy","Cloud VMs low energy", "Edge servers low energy"])
    plt.title(main_scenario)
    plt.show()
    figure = plt.gcf()
    figure.set_size_inches(15, 4)
    plt.savefig('resource_numbers_'+main_scenario+'.pdf') 
    
def draw_best_Baron_profit_ratio(scenarios,main_senario):
    X=[x for x in range(50, 450,50)]
    
    width = 0.2
    get_ipython().run_line_magic('matplotlib', 'qt')
    
    fig = plt.figure()
    N_total=np.arange(len([x for x in X ])) 
    diff=0
    for scenario in scenarios:
        list_P_edge=[]
        list_P_cloud=[]
        list_P_dep1=[]
        list_best_P=[]
        list_Baron_P=[]
        
        for N in X:
            
            best_P=0
            Baron_err=0
            feasible_Baron=0
          
            for Ins in [1,2,3,4,5,6,7,8,9,10]:
                
                Path="output_"+scenario+"/"+str(N)+"users/Ins"+str(Ins)
                best_P=np.load(Path+"/best_P.npy")
                
                if path.isfile(Path+"/Baron_P.npy") and np.load(Path+"/Baron_P.npy")>0:
                    P_Baron=np.load(Path+"/Baron_P.npy")
                    Baron_err+=((best_P-P_Baron)*100)/best_P
                    feasible_Baron+=1
                 
            
            
            if feasible_Baron>0:
                list_Baron_P.append(Baron_err/feasible_Baron)
              
        
       
        ax = plt.subplot(111)
        #ax.bar(N-0.1, list_P_cloud, width)
        ax.bar(N_total, list_Baron_P, width)
       
        
   
    plt.xticks(N_total, [str(x) for x in X] )
    plt.xlabel("Number of users")
    plt.ylabel("Platform profit ratio (%)")
    #plt.legend([ "High energy",   "Low energy"])
    plt.title(main_senario)
    plt.yscale("linear")
    plt.show()
    figure = plt.gcf()
    figure.set_size_inches(6, 4)
    plt.savefig('best_Baron_ratio_'+main_senario+'.pdf') 

def draw_best_all_dep1_profit_ratio(scenarios,main_senario):
    X=[x for x in range(50, 1050,50)]
    
    width = 0.2
    get_ipython().run_line_magic('matplotlib', 'qt')
    
    fig = plt.figure()
    N_total=np.arange(len([x for x in X ])) 
    diff=0
    for scenario in scenarios:
        
        list_P_dep1=[]
        list_best_P=[]
        for N in X:
            
            dep1_err=0
            best_P=0
            
          
            for Ins in [1,2,3,4,5,6,7,8,9,10]:
                
                Path="output_"+scenario+"/"+str(N)+"users/Ins"+str(Ins)
                best_P=np.load(Path+"/best_P.npy")
                
                P_dep1=np.load(Path + '/all_dep1_P.npy')
                dep1_err+=((best_P-P_dep1)*100)/best_P
                
                 
            
            
            list_P_dep1.append(dep1_err/10)
           
       
        ax = plt.subplot(111)
        #ax.bar(N-0.1, list_P_cloud, width)
        ax.bar(N_total+diff-0.1, list_P_dep1, width)
        diff+=0.2
        
   
    plt.xticks(N_total, [str(x) for x in X] )
    plt.xlabel("Number of users")
    plt.ylabel("Platform profit ratio (%)")
    plt.legend([ "High energy",   "Low energy"])
    plt.title(main_senario)
    plt.show()
    figure = plt.gcf()
    figure.set_size_inches(13, 4)
    plt.savefig('best_dep1_ratio_'+main_senario+'.pdf') 

def draw_only_cloud_profit(scenarios,main_senario):
    X=[x for x in range(50, 1050,50)]
    
    width = 0.2
    get_ipython().run_line_magic('matplotlib', 'qt')
    
    fig = plt.figure()
    N_total=np.arange(len([x for x in X ])) 
    diff=0
    for scenario in scenarios:
        list_P_edge=[]
        list_P_cloud=[]
        list_P_dep1=[]
        list_best_P=[]
        list_Baron_P=[]
        
        for N in X:
            cloud=0
           
            best_P=0
           
          
            for Ins in [1,2,3,4,5,6,7,8,9,10]:
                
                Path="output_"+scenario+"/"+str(N)+"users/Ins"+str(Ins)
              
                P_cloud=np.load(Path + '/only_cloud_P.npy')
                cloud+=P_cloud
            
            list_P_cloud.append(cloud/10)
           
        
        ax = plt.subplot(111)
        #ax.bar(N-0.1, list_P_cloud, width)
        ax.bar(N_total+diff-0.2, list_P_cloud, width)
        diff+=0.2
        
   
    plt.xticks(N_total, [str(x) for x in X] )
    plt.xlabel("Number of users")
    plt.ylabel("Platform profit")
    plt.legend([ "High energy",   "Low energy"])
    plt.title(main_senario)
    plt.show()
    figure = plt.gcf()
    figure.set_size_inches(13, 4)
    plt.savefig('onlyCloud_Profit_'+main_senario+'.pdf') 
       
def main():
   
   
    
    
    scenarios=["mixed_high_E","mixed_low_E"]
    main_senario="mixed"
    draw_resource_numbers(scenarios,main_senario)
    draw_best_all_dep1_profit_ratio(scenarios,main_senario)
    draw_only_cloud_profit(scenarios,main_senario)
    
    draw_best_only_cloud_all_dep1_social_walfare(scenarios,main_senario)
   
    draw_dep(scenarios,main_senario)
   
    scenarios=["mixed_high_E"]
    main_senario="mixed"
    draw_best_Baron_profit_ratio(scenarios,main_senario)
    draw_bar_time_profit()
    draw_Baron_proposed_compare()
    
   
            
            
        
            
if __name__ == '__main__':
    
   

    main()