import json
import numpy as np
import math


class System:
    
    
    def __init__(self, N, D, system_file = ""):
        self.N=N
        self.D=D
        if system_file != "":
           
            self.read_configuration_file(system_file)
        
        
            
    def read_configuration_file(self, system_file):
        
        # load json file
        with open(system_file) as f:
            data = json.load(f)
        if "Lambda" in data.keys():
            self.Lambda=data["Lambda"]
        if "Deployments" in data.keys():
           Dep =data["Deployments"]
           self.memory=np.array([0 for i in range(len(Dep))],dtype=float)
           self.data_size=np.array([0 for i in range(len(Dep))],dtype=float)
           for idx, dep in enumerate(Dep):
              self.memory[idx]= Dep[dep]["memory"]
              self.data_size[idx]= Dep[dep]["data_size"]
        if "Edge" in data.keys():
            demand =data["Edge"]["demand"]
            self.D_e=np.array([0 for i in range(len(demand))],dtype=float)
            for idx, dem in enumerate(demand):
                self.D_e[idx]= demand[dem]
            self.Beta_e=data["Edge"]["Beta_e"]
            self.N_e=data["Edge"]["max_VM_number"]
            self.edge_energy_consumption=data["Edge"]["edge_energy_consumption"]
        if "Cloud" in data.keys():
            demand =data["Cloud"]["demand"]
            self.D_c=np.array([0 for i in range(len(demand))],dtype=float)
            for idx, dem in enumerate(demand):
                self.D_c[idx]= demand[dem]
            self.VM_cost=data["Cloud"]["cost"]
        if "T" in data.keys():
            self.T=data["T"]
        if "mu" in data.keys():
            self.mu=data["mu"]
        if "U_min" in data.keys():
            self.U_min=data["U_min"]
        if "U_max" in data.keys():
            self.U_max=data["U_max"]
        
        if "R_constraints" in data.keys():
            self.R_bar=data["R_constraints"]
        if "gamma" in data.keys():
            self.gamma=data["gamma"]
            
    def compute_opt_n_e_c(self,Lambdas,R_bar_bar):
    
    
        if Lambdas[1] <= self.N_e*(R_bar_bar-self.D_e[1])/(R_bar_bar*self.D_e[1]):
            n_e_closed= R_bar_bar*self.D_e[1]*Lambdas[1]/(R_bar_bar-self.D_e[1])
            if n_e_closed>round(n_e_closed):
                      n_e_closed=round(n_e_closed)+1
            else:
                      n_e_closed=round(n_e_closed)
            Lambda_e_closed=Lambdas[1]
            n_c_closed=0
            Lambda_c_closed=0
        else:
             if self.Lambda > self.N_e*(R_bar_bar-self.D_e[1])/(R_bar_bar*self.D_e[1]) :
                n_c_closed= (self.D_e[1]* Lambdas[1] *R_bar_bar)/ (R_bar_bar-self.D_c[1])
                if n_c_closed>round(n_c_closed):
                    n_c_closed=round(n_c_closed)+1
                else:
                    n_c_closed=round(n_c_closed)
                n_e_closed=0
                Lambda_c_closed=Lambdas[1]
                Lambda_e_closed=0
                return n_e_closed, Lambda_e_closed, n_c_closed, Lambda_c_closed
             n_e_closed=self.N_e
             n_c_closed=self.D_c[1]*Lambdas[1]*(R_bar_bar*self.D_e[1]*Lambdas[1]-self.N_e*(R_bar_bar-self.D_e[1]))/(self.N_e*(math.sqrt(self.D_e[1])- math.sqrt(self.D_c[1]))**2 + self.D_e[1]*Lambdas[1]*(R_bar_bar-self.D_c[1]) )
             if n_c_closed>round(n_c_closed):
                   n_c_closed=round(n_c_closed)+1
                   n_e_closed= (self.D_c[1]*self.D_e[1]*Lambdas[1]*Lambdas[1]*R_bar_bar-n_c_closed*self.D_e[1]*Lambdas[1]*(R_bar_bar-self.D_c[1]))/(n_c_closed*(math.sqrt(self.D_e[1])- math.sqrt(self.D_c[1]))**2 + self.D_c[1]*Lambdas[1]*(R_bar_bar-self.D_e[1]))
                   if n_e_closed>0:
                       if n_e_closed>round(n_e_closed):
                          n_e_closed=round(n_e_closed)+1
                       else:
                          n_e_closed=round(n_e_closed)
                       Lambda_e_closed= n_e_closed*Lambdas[1]*(R_bar_bar-math.sqrt(self.D_e[1]*self.D_c[1]))/( n_e_closed * self.D_e[1] + R_bar_bar*Lambdas[1]*self.D_e[1] -  n_e_closed * math.sqrt(self.D_e[1]*self.D_c[1]))
                       Lambda_e_closed=int(Lambda_e_closed/self.Lambda)*self.Lambda
                   else:
                         n_e_closed=0
                         Lambda_e_closed=0
             else:
                   n_c_closed=round(n_c_closed)
                   n_e_closed= (self.D_c[1]*self.D_e[1]*Lambdas[1]*Lambdas[1]*R_bar_bar-n_c_closed*self.D_e[1]*Lambdas[1]*(R_bar_bar-self.D_c[1]))/(n_c_closed*(math.sqrt(self.D_e[1])- math.sqrt(self.D_c[1]))**2 + self.D_c[1]*Lambdas[1]*(R_bar_bar-self.D_e[1]))
                   if n_e_closed>0:
                       if n_e_closed>round(n_e_closed):
                          n_e_closed=round(n_e_closed)+1
                       else:
                          n_e_closed=round(n_e_closed)
                       Lambda_e_closed= n_e_closed*Lambdas[1]*(R_bar_bar-math.sqrt(self.D_e[1]*self.D_c[1]))/( n_e_closed * self.D_e[1] + R_bar_bar*Lambdas[1]*self.D_e[1] -  n_e_closed * math.sqrt(self.D_e[1]*self.D_c[1]))
                       Lambda_e_closed=int(Lambda_e_closed/self.Lambda)*self.Lambda
                   else:
                        n_e_closed=0
                        Lambda_e_closed=0
                      
             Lambda_c_closed=Lambdas[1]-Lambda_e_closed
        return n_e_closed, Lambda_e_closed, n_c_closed, Lambda_c_closed
                       
    def compute_R_bar_bar_Lambda(self, users, x):
       
       
        Lambdas=np.array([0 for i in range(self.D)],dtype=float)
        for k in range(self.D):
            L=0
            for i in range(self.N):
               L+=self.Lambda*x[i][k] 
            Lambdas[k]= L
        ED=0
        counter=0
        for i in range(self.N):
            for k in range(self.D):
                if k==1:
                    counter+=1*x[i][k]
                    ED+=users.demands[i][k]*x[i][k]+(self.data_size[k]*x[i][k])/users.B[i]
        #pdb.set_trace()
        if counter>0:
            R_bar_bar=self.R_bar-ED/counter#(N*D)
        else:
            R_bar_bar=0
       
           
        return R_bar_bar, Lambdas
            
    def search_string_in_file(self,file_name, string_to_search):
        """Search for the given string in file and return lines containing that string,
        along with line numbers"""
        line_number = 0
        list_of_results = []
        # Open the file in read only mode
        with open(file_name, 'r') as read_obj:
            # Read all lines in the file one by one
            for line in read_obj:
                # For each line, check if line contains the string
                line_number += 1
                if string_to_search in line:
                    # If yes, then add the line number & line as a tuple in the list
                    list_of_results.append((line_number, line.rstrip()))
     
        # Return list of tuples containing line numbers and lines where string is found
        return list_of_results
    
    def write_param_2D_in_platform_file(self,N,D,file_name, paramName, paramList):
            
            matched_lines=self.search_string_in_file(file_name, paramName)
           # pdb.set_trace()
            From_delete_line = matched_lines[0][0]+1
            matched_lines = self.search_string_in_file(file_name, ';')
            #pdb.set_trace()
            To_delete_line = [element[0] for element in matched_lines if element[0] > From_delete_line][0]
            #To_delete_line = matched_lines[len(matched_lines)-1][0]
            self.RemoveLines(file_name,From_delete_line-2, To_delete_line)
            f1 = open(file_name)
            lines = f1.readlines()
            f1.close()
             # num for some line number
            lines.insert(From_delete_line-2, 'param ' + paramName + '= \n')
            k1=0
            for i in range(N):
                    for k in range(D):
                        lines.insert(From_delete_line+k1-1, 'u'+str(i+1) + ' ' + 's'+ str(k+1) + ' ' + str(paramList[i][k]) + '\n' )
                        k1+=1
            lines.insert(From_delete_line+k1-1, '; \n' )
            
            f1 = open(file_name,'a+')
            f1.truncate(0)
            f1.writelines(lines)
            f1.close()
    
    def write_set_of_users_in_platform_file(self,file_name, paramName,UsersNumbers):
          
            matched_lines=self.search_string_in_file(file_name, paramName)
            pdb.set_trace()
            From_delete_line = matched_lines[0][0]
            matched_lines = self.search_string_in_file(file_name, ';')
            #pdb.set_trace()
            To_delete_line = [element[0] for element in matched_lines if element[0] >= From_delete_line][0]
            #To_delete_line = matched_lines[len(matched_lines)-1][0]
            self.RemoveLines(file_name,From_delete_line-1, To_delete_line)
            f1 = open(file_name)
            lines = f1.readlines()
            f1.close()
             # num for some line number
            lines.insert(From_delete_line-1, 'set Users :=')
            
            
            for i in range(UsersNumbers):
                lines[From_delete_line-1]=lines[From_delete_line-1] + " u"+ str(i+1) 
               
            lines[From_delete_line-1]=lines[From_delete_line-1] +  '; \n' 
           # pdb.set_trace()
            # f1 = open(file_name,'a+')
            # f1.truncate(0)
            # f1.writelines(lines)
            # f1.close()     
            
            with open(file_name, "a+") as file_object:
                appendEOL = False
                # Move read cursor to the start of file.
                file_object.seek(0)
                # Check if file is not empty
                data = file_object.read(100)
                if len(data) > 0:
                    appendEOL = True
                # Iterate over each string in the list
                for line in lines:
                    # If file is not empty then append '\n' before first line for
                    # other lines always append '\n' before appending line
                    if appendEOL == True:
                        file_object.write("\n")
                    else:
                        appendEOL = True
                    # Append element at the end of file
                    file_object.write(line)
    
    def write_param_1D_in_platform_file(self,D,file_name, paramName, paramList,paramString):
          
            matched_lines=self.search_string_in_file(file_name, paramName)
           # pdb.set_trace()
            From_delete_line = matched_lines[0][0]+1
            matched_lines = self.search_string_in_file(file_name, ';')
            #pdb.set_trace()
            To_delete_line = [element[0] for element in matched_lines if element[0] > From_delete_line][0]
            #To_delete_line = matched_lines[len(matched_lines)-1][0]
            self.RemoveLines(file_name,From_delete_line-2, To_delete_line)
            f1 = open(file_name)
            lines = f1.readlines()
            f1.close()
             # num for some line number
            lines.insert(From_delete_line-2, 'param ' + paramName + '= \n')
            k1=0
            
            for k in range(D):
                lines.insert(From_delete_line+k1-1,paramString+ str(k+1) + ' ' + str(paramList[k]) + '\n' )
                k1+=1
            lines.insert(From_delete_line+k1-1, '; \n' )
            
            f1 = open(file_name,'a')
            f1.truncate(0)
            f1.writelines(lines)
            f1.close()      
            
    def write_param_0D_in_platform_file(self,file_name, paramName, param):
            matched_lines=self.search_string_in_file(file_name, paramName)
           # pdb.set_trace()
            From_delete_line = matched_lines[0][0]
            matched_lines = self.search_string_in_file(file_name, ';')
            #pdb.set_trace()
            To_delete_line = [element[0] for element in matched_lines if element[0] >= From_delete_line][0]
            #To_delete_line = matched_lines[len(matched_lines)-1][0]
            self.RemoveLines(file_name,From_delete_line-1, To_delete_line)
            f1 = open(file_name)
            lines = f1.readlines()
            f1.close()
             # num for some line number
            lines.insert(From_delete_line-1, 'param ' + paramName + '= '+ str(param)+  '; \n')
            
            
            f1 = open(file_name,'a')
            f1.truncate(0)
            f1.writelines(lines)
            f1.close()  
    def RemoveLines(self,fileName, start, end):
        """Remove lines from start ot end"""
        tempFile = open(fileName)
        tempList = []
        for lineNum, line in enumerate(tempFile):
            if lineNum >= start and lineNum < end:
                continue  # do next lineNum, line without append()
            tempList.append(line)
        #tempFile.close()
        tempFile = open(fileName, 'w+')
        tempFile.writelines(tempList)
        tempFile.close()
    
    def initialize_variable(self,N, y_e, y_c):
        dec_e={}
        for i in range(N):
            name="u" + str(i+1)
            dec_e[name]=y_e[i]
        dec_c={}
        for i in range(N):
            name="u" + str(i+1)
            dec_c[name]=y_c[i]
        return dec_e, dec_c
            
    
        
        