import pyomo.environ as pyo
import numpy as np
import pdb

class PlatformModel:
    
    def __init__(self):
        self.eps=0.00001
        
        
    
    def platform_revenue(self, S,x,U,n_e,n_c):
        cost= self.platform_resource_cost(S,n_e,n_c)
        t=0
        for i in range(S.N):
            for k in range(S.D):
                cost+=x[i][k]*U[k]
            t=t+np.log(1+x[i][0]+x[i][1])
               # t=t+x[i][0]+x[i][1]
        
        revenue=S.mu*np.log(1+t)-cost
        return revenue
    
    def platform_resource_cost(self,S, n_e,n_c):
       
        cost= S.T*(S.Beta_e * S.edge_energy_consumption * n_e + S.VM_cost* n_c)
        return cost

    


    
    def creat_platform_model(self, input_file, S ):
        self.gamma=S.gamma
     # Sets
        model = pyo.AbstractModel()
        #data = pyo.DataPortal()
        model.Users = pyo.Set()
        #model.Partitions=pyo.Set()
        model.Deployments = pyo.Set()
       
        
        # Parameters
        model.data_size=pyo.Param(model.Deployments,default=0.0,mutable=True)
        #model.memory_requirement=pyo.Param(model.Deployments,default=0.0,mutable=True)
        model.edge_energy_coefficient=pyo.Param(default=0.0,mutable=True)
        model.s=pyo.Param(model.Users,model.Deployments, default=0.0)
        model.C=pyo.Param(model.Users,model.Deployments, default=0.0,mutable=True)
        model.max_edge_number=pyo.Param(default=0.0,mutable=True)
        model.edge_energy_consumption=pyo.Param(default=0.0,mutable=True)
        model.VM_cost=pyo.Param(default=0.0,mutable=True)
        model.user_demand_matrix=pyo.Param(model.Users,model.Deployments,default=0.0,mutable=True)
        model.edge_demand_matrix=pyo.Param(model.Deployments,default=0.0,mutable=True)
        model.VM_demand_matrix=pyo.Param(model.Deployments,default=0.0,mutable=True)
        model.time=pyo.Param(model.Users,default=0.0,mutable=True)
        model.Lambda=pyo.Param(default=0.0,mutable=True)
        model.R_constraints=pyo.Param(default=0.0,mutable=True)
        model.network_Bandwidth=pyo.Param(model.Users,  default=0.0,mutable=True)
        model.mu=pyo.Param(default=S.mu,mutable=True)
        model.M = pyo.Param(default=10000000,mutable=True)
        model.U_max = pyo.Param(default=S.U_max,mutable=True)
        model.U_min = pyo.Param(default=S.U_min,mutable=True)
        
        
        #model.Utility=pyo.Param(model.Users,default=0.0,mutable=True)
       # model.M = pyo.Param(default=10000,mutable=True)
        model.T = pyo.Param(default=1,mutable=True)
        
        # Variables
        
        model.edge_number=pyo.Var(model.Deployments,within=pyo.NonNegativeIntegers )
        model.VM_number=pyo.Var(model.Deployments,within=pyo.NonNegativeIntegers)
        model.y_e=pyo.Var(model.Users, within=pyo.Boolean)
        model.y_c=pyo.Var(model.Users, within=pyo.Boolean)
        model.U = pyo.Var(model.Deployments ,within=pyo.NonNegativeReals)
        model.x=pyo.Var(model.Users,model.Deployments,initialize=0 ,within=pyo.Boolean)
        model.t=pyo.Var(model.Users,model.Deployments,initialize=0 ,within=pyo.Boolean)
        model.z=pyo.Var(model.Users,model.Deployments,initialize=0 ,within=pyo.Boolean)
        
     
        #Constraints
        model.edge_number_constraints = pyo.Constraint(rule=self.edge_number_constraint_MCS)
        model.edge_saturation_constraints=pyo.Constraint(model.Deployments, rule=self.edge_saturation_constraint_MCS)
        
        model.cloud_saturation_constraints=pyo.Constraint(model.Deployments, rule=self.cloud_saturation_constraint_MCS)
       
       # model.connection_constraints=pyo.Constraint(model.Deployments, rule=connection_constraint)
        model.response_time_constraints=pyo.Constraint(model.Users,rule=self.response_time_constraint_MCS)
        model.y_constraints=pyo.Constraint(model.Users,rule=self.y_constraint_MCS)
        
        model.profit_constraints_1_1=pyo.Constraint(model.Users,model.Deployments,rule=self.profit_constraint_1_1)
        model.profit_constraints_1_2=pyo.Constraint(model.Users,model.Deployments,rule=self.profit_constraint_1_2)
        
        model.U_constraints=pyo.Constraint(rule=self.U_constraint)
        model.U_min_constraints=pyo.Constraint(rule=self.U_constraint_min)
        model.U_max_constraints=pyo.Constraint(rule=self.U_constraint_max)
        
        
        model.best_dep_constraints_1_1=pyo.Constraint(model.Users,rule=self.best_dep_constraint_1_1)
        model.best_dep_constraints_1_2=pyo.Constraint(model.Users,rule=self.best_dep_constraint_1_2)
        model.best_dep_constraints_2_1=pyo.Constraint(model.Users,rule=self.best_dep_constraint_2_1)
        model.best_dep_constraints_2_2=pyo.Constraint(model.Users,rule=self.best_dep_constraint_2_2)
        
        model.constraints_st=pyo.Constraint(model.Users,model.Deployments,rule=self.constraint_st)
        model.constraints_szt_1=pyo.Constraint(model.Users,model.Deployments,rule=self.constraint_szt_1)
        model.constraints_szt_2=pyo.Constraint(model.Users,model.Deployments,rule=self.constraint_szt_2)
        
        
        
        model.only_one_dep_constraints=pyo.Constraint(model.Users,rule=self.only_one_dep_constraint)
    
        # Objective function
        
        model.Maximum_edge_profit=pyo.Objective(rule=self.objective_function_MCS, sense=pyo.maximize )
        
        #model=model
        data=self.load_platform_data(input_file, model)
        return data, model
       
        
       
       
    def objective_function_MCS(self, model):
        return model.mu*pyo.log(1 +sum(pyo.log(1 + sum(model.x[i,k]for k in model.Deployments))for i in model.Users) )\
            -sum(model.x[i,k]*model.U[k] for k in model.Deployments for i in model.Users)\
            -sum(model.T * model.edge_energy_coefficient * model.edge_energy_consumption * model.edge_number[k] for k in model.Deployments)\
                - sum( model.T * model.VM_cost * model.VM_number[k] for k in model.Deployments)
        
   
    def  edge_number_constraint_MCS(self, model):
     
        return sum(model.edge_number[k] for k in model.Deployments)<=model.max_edge_number
    
    def  y_constraint_MCS(self, model, i):
        
        
            
        return  model.y_e[i]+model.y_c[i]==sum(model.x[i,k] for k in model.Deployments if k != "s1")
    
    
    def  edge_saturation_constraint_MCS(self, model, k):
        
        
        if k == "s1":
            return pyo.Constraint.Skip
        return model.edge_number[k] - self.eps>=sum(model.edge_demand_matrix[k] * model.x[i,k] * model.Lambda *  model.y_e[i] for i in model.Users)
       
    def  cloud_saturation_constraint_MCS(self, model, k):
       
        if k == "s1":
            return pyo.Constraint.Skip
      
        return model.VM_number[k] - self.eps>=sum(model.VM_demand_matrix[k] * model.x[i,k] * model.Lambda *  model.y_c[i] for i in model.Users)
       
    def response_time_constraint_MCS(self, model, i):
        
        return sum(model.user_demand_matrix[i,k] * model.x[i,k] for k in model.Deployments)+\
            sum(model.data_size[k] * model.x[i,k]/model.network_Bandwidth[i] for k in model.Deployments)+\
            sum((model.edge_number[k] * model.edge_demand_matrix[k] * model.x[i,k] * model.y_e[i])/(model.edge_number[k]-sum(model.edge_demand_matrix[k] * model.x[i1,k] * model.Lambda *  model.y_e[i1] for i1 in model.Users))for k in model.Deployments if k != "s1")+\
                sum((model.VM_number[k] * model.VM_demand_matrix[k] * model.x[i,k] * model.y_c[i])/(model.VM_number[k]-sum(model.VM_demand_matrix[k] * model.x[i1,k] * model.Lambda *  model.y_c[i1] for i1 in model.Users))for k in model.Deployments if k != "s1") <= model.R_constraints
    
    def U_constraint(self, model):
        k1 = "s1"
        k2 = "s2"
        
        return model.U[k2]==self.gamma*model.U[k1]
    
    def U_constraint_max(self, model):
        k1 = "s1"
        return model.U[k1]<=model.U_max
    
    def U_constraint_min(self, model):
        k1 = "s1"
        return model.U[k1]>=model.U_min
        
    def  profit_constraint_1_1(self, model, i,k):
        # if model.s[i,k]<=0:
        #     return pyo.Constraint.Skip
        return (1-model.t[i,k])*model.M*(-1)<=model.U[k]-model.C[i,k] 
    def  profit_constraint_1_2(self, model, i,k):
        # if model.s[i,k]<=0:
        #     return pyo.Constraint.Skip
        return  model.U[k]-model.C[i,k] <=model.t[i,k]*model.M
    
    def  best_dep_constraint_1_1(self, model, i):
        k1="s1"
        k2="s2"
        return (1-model.z[i,k1])*model.M*(-1)<=(model.U[k1]-model.C[i,k1])-(model.U[k2]-model.C[i,k2])
    def  best_dep_constraint_1_2(self, model, i):
        k1="s1"
        k2="s2"
        return (model.U[k1]-model.C[i,k1])-(model.U[k2]-model.C[i,k2]) <= model.z[i,k1]*model.M
    def  best_dep_constraint_2_1(self, model, i):
        k1="s1"
        k2="s2"
        return (1-model.z[i,k2])*model.M*(-1)<=(model.U[k2]-model.C[i,k2])-(model.U[k1]-model.C[i,k1])
    def  best_dep_constraint_2_2(self, model, i):
        k1="s1"
        k2="s2"
        return (model.U[k2]-model.C[i,k2])-(model.U[k1]-model.C[i,k1]) <= model.z[i,k2]*model.M
    
    
    
    def constraint_st(self, model, i, k):
        
        return model.x[i,k]<=model.s[i,k]*model.t[i,k]
    
    
    def constraint_szt_1(self, model, i, k):
        k1="s1"
        k2="s2"
        
        return model.x[i,k1]>=model.s[i,k1]*model.t[i,k1]+model.s[i,k2]*(model.z[i,k1]-1)
    
    def constraint_szt_2(self, model, i, k):
        k1="s1"
        k2="s2"
        
        return model.x[i,k2]>=model.s[i,k2]*model.t[i,k2]+model.s[i,k1]*(model.z[i,k2]-1)
    
    def  only_one_dep_constraint(self, model, i):
        
        return sum(model.x[i,k] for k in model.Deployments)<= 1
    
    
    
    def load_platform_data(self,file_name, PlatformModel):
        PlatformData = pyo.DataPortal(model=PlatformModel)
        #PlatformData.load(filename=file_name)
        PlatformData.load(filename=file_name, Set=PlatformModel.Users, format="set")
        PlatformData.load(filename=file_name, Set=PlatformModel.Deployments, format="set")
       
        PlatformData.load(filename=file_name, Param=PlatformModel.data_size, format="param")
        PlatformData.load(filename=file_name, Param=PlatformModel.edge_energy_coefficient, format="param")
        PlatformData.load(filename=file_name, Param=PlatformModel.s, format="param")
        PlatformData.load(filename=file_name, Param=PlatformModel.C, format="param")
        
        PlatformData.load(filename=file_name, Param=PlatformModel.max_edge_number, format="param")
        PlatformData.load(filename=file_name, Param=PlatformModel.edge_energy_consumption, format="param")
        PlatformData.load(filename=file_name, Param=PlatformModel.VM_cost, format="param")
        PlatformData.load(filename=file_name, Param=PlatformModel.user_demand_matrix, format="param")
        PlatformData.load(filename=file_name, Param=PlatformModel.edge_demand_matrix, format="param")
        PlatformData.load(filename=file_name, Param=PlatformModel.VM_demand_matrix, format="param")
        PlatformData.load(filename=file_name, Param=PlatformModel.Lambda, format="param")
        PlatformData.load(filename=file_name, Param=PlatformModel.R_constraints, format="param")
        PlatformData.load(filename=file_name, Param=PlatformModel.network_Bandwidth, format="param")
        PlatformData.load(filename=file_name, Param=PlatformModel.time, format="param")
        
        PlatformData.load(filename=file_name, Param=PlatformModel.T, format="param")
        return PlatformData
    
    
    
class UserModel:
    
    def __init__(self, S):
      
        self.generate_random_user_parameters(S)
    
    def generate_random_user_parameters( self,S):
        
        beta=np.array([1.3*S.Beta_e for i in range(S.N)],dtype=float)
        E=np.array([0 for i in range(S.N)],dtype=float)
        M=np.array([0 for i in range(S.N)],dtype=int)
        #m=np.array([0 for i in range(D)],dtype=int)
        e=np.array([[0 for it2 in range(S.D)] for it1 in range(S.N)],dtype=float)
        demands=np.array([[0 for it2 in range(S.D)] for it1 in range(S.N)],dtype=float)
        T_i=np.array([3600 for i in range(S.N)],dtype=float)
        B=np.array([0 for i in range(S.N)],dtype=float)
        
        for i in range(S.N):
            demands[i][0]=round(np.random.uniform(0.07,0.09),5)
            demands[i][1]=round(np.random.uniform(0.02,0.04),5)
            e[i][0]=(demands[i][0]/0.09)*9
            e[i][1]=(demands[i][1]/0.04)*8
            #B[i]=round(np.random.uniform(20000000,40000000),2)
           # num=np.random.uniform(0.5, 2)
            #E[i]=round(np.random.uniform(e[i][0]*T_i[i]*num, e[i][0]*T_i[i]*num),3)
           # if (i % 4) == 0:
            #    B[i]=round(np.random.uniform(20000000,40000000),2)
           # else:
            B[i]=round(np.random.uniform(5000000,10000000),2)
            #if (i % 2)==0:
             #    E[i]=round(np.random.uniform(e[i][1]*T_i[i], e[i][0]*T_i[i]),3)
            #else:
            E[i]=round(np.random.uniform(e[i][0]*T_i[i]*2, e[i][0]*T_i[i]*3),3)
            M[i]=np.random.randint(S.D*5,S.D*6)
           
        self.beta=beta
        self.max_energy=E
        self.max_memory=M
        self.dep_power_consumption=e
        self.demands=demands
        self.B=B
        self.T=T_i
    
    def users_memory_energy_checking_cost(self, S):
   
        s=np.array([[0 for it2 in range(S.D)] for it1 in range(S.N)],dtype=float)
        c=np.array([[0 for it2 in range(S.D)] for it1 in range(S.N)],dtype=float)
        for i in range(S.N):
            for k in range(S.D):
                c[i][k]=self.T[i]*S.Lambda* (self.dep_power_consumption[i][k]*self.beta[i])
                if self.dep_power_consumption[i][k]*self.T[i]<=self.max_energy[i] and S.memory[k]<=self.max_memory[i] :
                    s[i][k]=1
        
                
        return s,c


    def solve_users_problem(self, S, U):
       
        best_solution=np.array([-1 for i in range(S.N)],dtype=int)
        x=np.array([[0 for it2 in range(S.D)] for it1 in range(S.N)],dtype=float)
        for i in range(S.N):
            best_profit=0
            for k in range(S.D-1,-1, -1):
                
                profit =U[k]-self.T[i]*S.Lambda* (self.dep_power_consumption[i][k]*self.beta[i])
                
                if profit>best_profit and self.T[i]*self.dep_power_consumption[i][k]<=self.max_energy[i] and S.memory[k]<=self.max_memory[i]:
                    best_profit=profit
                    best_solution[i]=k
                    
        for i in range(S.N):
           if best_solution[i]>-1: 
               x[i][best_solution[i]]=1
           
                
        return x
    
    def compute_users_social_welfare(self,S,x, U):
       social_welfare=0 
       for i in range(S.N):
               
           social_welfare +=sum(x[i][k]*(U[k]-self.T[i]*S.Lambda*self.dep_power_consumption[i][k]*self.beta[i]) for k in range( S.D))
       return social_welfare
   
    
   
