import sys
import copy
import multiprocessing as mpp
from multiprocessing import Queue
import pyomo.environ as pyo
import numpy as np
from pyomo.opt import SolverFactory
import pdb
import random
import json
import matplotlib.pyplot as plt
import time
from numpy import linalg as LNG 
from multiprocessing import Process, Pool
import os
import shutil
import math
from classes.System import System
from classes.Model import PlatformModel, UserModel
from classes.Algorithm import Algorithm
import re
from os import path 
from IPython import get_ipython

from mpl_toolkits.axes_grid1 import make_axes_locatable
from matplotlib.ticker import (MultipleLocator, FormatStrFormatter,
                               AutoMinorLocator)




def generate_random_system_file(N,system_file,new_file_name, Lambda_range,  D_c_range, data_size_range, VM_cost_range, 
                                edge_energy_consumption_range, mu_range, R_bar_range, gamma_range, Beta_e_range):
    
    D_c=round(np.random.uniform(D_c_range[0],D_c_range[1]),5)
    D_e=D_c*6/5
    Lambda=round(np.random.uniform(Lambda_range[0],Lambda_range[1]),2)
    data_size=round(np.random.uniform(data_size_range[0],data_size_range[1]),3)
    VM_cost=round(np.random.uniform(VM_cost_range[0],VM_cost_range[1]),5)
    
    #N_e=np.random.randint(20*D_e*Lambda*math.log10(N), 50*D_e*Lambda*math.log10(N))
    #N_e=20*D_e*Lambda*math.log10(350)+((N-350)/50)*2
    N_e=int(N/23)
    edge_energy_consumption=round(np.random.uniform(edge_energy_consumption_range[0],edge_energy_consumption_range[1]),2)
    mu=np.random.randint(mu_range[0], mu_range[1])
    R_bar=round(np.random.uniform(R_bar_range[0],R_bar_range[1]),2)
    gamma=round(np.random.uniform(gamma_range[0],gamma_range[1]),2)
    kwh_to_ws=1/3600000
    Beta_e=round(np.random.uniform(Beta_e_range[0],Beta_e_range[1]),4)*kwh_to_ws
   # pdb.set_trace()
    
    with open(system_file, "r") as a_file:
        json_object = json.load(a_file)
    json_object["Lambda"] = Lambda
    json_object["Deployments"]["k1"]["data_size"] = data_size*8/10  # the output data size of dep2 is 10 times larger than dep1
    json_object["Deployments"]["k2"]["data_size"] = data_size*8  #convert byte to bit
    json_object["Edge"]["demand"]["k1"] = 0
    json_object["Edge"]["demand"]["k2"] = D_e
    json_object["Cloud"]["demand"]["k1"] = 0
    json_object["Cloud"]["demand"]["k2"] = D_c
    json_object["Edge"]["max_VM_number"]=N_e
    json_object["Edge"]["edge_energy_consumption"]=edge_energy_consumption
    json_object["Edge"]["Beta_e"]=Beta_e
    json_object["Cloud"]["cost"]=VM_cost
    json_object["mu"]=mu
    json_object["R_constraints"]=R_bar
    json_object["gamma"]=gamma
    
    
    with open(new_file_name, "w") as a_file:
       json.dump(json_object,a_file)
 
    
def compute_R_constraints(Path, N,S):
    
    users=UserModel(S)
    R_constraint=np.array([0 for i in range(N)],dtype=float)
    x=np.load(Path+'/best_x.npy')
    n_c=np.load(Path+'/best_n_c.npy')
    n_e=np.load(Path+'/best_n_e.npy')
    y_e=np.load(Path+'/best_y_e.npy')
    y_c=np.load(Path+'/best_y_c.npy')
    
    
    for i in range(N):
        
          
          R_constraint[i]=sum(users.demands[i][k]* x[i][k] for k in range(2))+\
              S.data_size[1] * x[i][1]/users.B[i]+\
                  sum((n_e * S.D_e[k] * x[i][k] * y_e[i])/(n_e-sum(S.D_e[k] * x[i1][k] * S.Lambda *  y_e[i1] for i1 in range(N)))for k in range(2) if (k != 0 and n_e>0) )+\
                      sum((n_c * S.D_c[k] * x[i][k] * y_e[i])/(n_c-sum(S.D_c[k] * x[i1][k] * S.Lambda *  y_c[i1]for i1 in range(N)))for k in range(2)if (k != 0 and n_c>0)) 
    flag=[x>S.R_bar for x in R_constraint]
    
    return flag
   



def only_edge_cloud_dep1(S,users, Path,system_file ):
   
        
        algorithm=Algorithm(S,users)
        P,cloud_x,cloud_U=algorithm.only_cloud()
        social_welfare=users.compute_users_social_welfare(S,cloud_x, cloud_U)
        np.save(Path + '/social_welfare_only_cloud.npy', social_welfare)
        np.save(Path + '/only_cloud_P.npy', P)
        np.save(Path + '/only_cloud_x.npy', cloud_x)
        np.save(Path + '/only_cloud_U.npy', cloud_U)
        
        P,dep1_x,dep1_U=algorithm.all_dep1_Baseline_alg()
        social_welfare=users.compute_users_social_welfare(S,dep1_x, dep1_U)
        np.save(Path + '/social_welfare_all_dep1.npy', social_welfare)
        np.save(Path + '/all_dep1_P.npy', P)
        np.save(Path + '/all_dep1_x.npy', dep1_x)
        np.save(Path + '/all_dep1_U.npy', dep1_U)
        
        feasible,P, edge_x, edge_U=algorithm.only_edge()
        social_welfare=users.compute_users_social_welfare(S,edge_x, edge_U)
        np.save(Path + '/social_welfare_only_edge.npy', social_welfare)
        np.save(Path + '/only_edge_P.npy', P)
        np.save(Path + '/only_edge_feasible.npy', feasible)
        np.save(Path + '/only_edge_x.npy', edge_x)
        np.save(Path + '/only_edge_U.npy', edge_U)
        
        x=np.load(Path + '/best_x.npy')
        U=np.load(Path + '/best_U.npy')
        social_welfare=users.compute_users_social_welfare(S,x, U)
        np.save(Path + '/social_welfare.npy', social_welfare)
        


    
    
            
def main(input_file):
   
    D=2
    X=[x for x in range(50, 1050,50)]
    
    for N in X :
        for seed in [1,2,3,4,5,6,7,8,9,10]:
             
            
            Lambda_range=[20, 70]
            D_c_range=[0.003, 0.005]
            data_size_range=[0.1, 0.3]
            VM_cost_range=[1/3600, 2/3600]
            edge_energy_consumption_range=[200, 250]
            mu_range=[100, 500]
            R_bar_range=[0.1, 0.5]
            gamma_range=[0.7, 0.8]
            Beta_e_range=[0.2, 0.25]
            
            model_file='ConfigFiles/MCS'+ str(N)+'users2Dep.dat'
           
            np.random.seed(seed)
            Path="output_mixed/" + str(N) + "users/Ins"+str(seed)
            
            new_file_name="output_mixed/"+str(N)+"users/Ins"+str(seed)+"/system_file.json"
            if not os.path.exists(Path):
                os.makedirs(Path)
            generate_random_system_file(N,input_file,new_file_name,Lambda_range,  D_c_range, data_size_range, VM_cost_range, 
                                        edge_energy_consumption_range, mu_range, R_bar_range, gamma_range, Beta_e_range)
           
            S=System(N, D,new_file_name)
            
            # Beta_e is between 0.184 and 0.25 dollar/KWatt/Hour, One kilowatt hour is 3.6 megajoules, 
            # which is the amount of energy converted if work is done at an average rate of one thousand watts for one hour.
           # kwh_to_ws=1/3600000
          #  Beta_e=0.2*kwh_to_ws#round(np.random.uniform(0.184,0.25),4)*kwh_to_ws
           # beta, e, E, M,T,Demands, data_size=Model.generate_random_user_parameters_MCS(N,D,Path,Lambda,Beta_e)
            users=UserModel(S)
            algorithm=Algorithm(S,users)
            only_edge_cloud_dep1(S,users,Path,new_file_name )
            start=time.time()
            batch_result=algorithm.Baseline_alg()
            batch_size=100
            best_P,best_n_c,best_n_e, best_Lambda_e, best_Lambda_c, best_U, best_x , best_y_e, best_y_c  =algorithm.best_resource_assignment(batch_result,batch_size)
            exec_time=time.time()-start
            np.save(Path + '/best_P.npy', best_P)
            np.save(Path + '/best_n_c.npy', best_n_c)
            np.save(Path + '/best_n_e.npy', best_n_e)
            np.save(Path + '/best_Lambda_e.npy', best_Lambda_e)
            np.save(Path + '/best_Lambda_c.npy', best_Lambda_c)
            np.save(Path + '/best_U.npy', best_U)
            np.save(Path + '/best_x.npy', best_x)
            np.save(Path + '/best_y_e.npy', best_y_e)
            np.save(Path + '/best_y_c.npy', best_y_c)
            np.save(Path + '/exec_time.npy', exec_time)
            
          
            # the cost of VM is 4$/h
         #  c=4/3600
           
            
            start=time.time()
            Baron_P, Baron_U, Baron_n_c, Baron_n_e, Baron_x, Baron_y_e, Baron_y_c,  R_constraint=algorithm.simple_algorithm(model_file, Path)   
            exec_time_Baron=time.time()-start
            only_edge_cloud_dep1(S,users,Path,new_file_name )
            print(str(N)+" users Instance "+ str(seed)+" done \n")
         
            np.save(Path + '/Baron_P.npy', Baron_P)
            np.save(Path + '/Baron_U.npy', Baron_U)
            np.save(Path + '/Baron_n_c.npy', Baron_n_c)
            np.save(Path + '/Baron_n_e.npy', Baron_n_e)
            np.save(Path + '/Baron_x.npy', Baron_x)
            np.save(Path + '/Baron_y_e.npy', Baron_y_e)
            np.save(Path + '/Baron_y_c.npy', Baron_y_c)
            np.save(Path + '/R_constraint.npy', R_constraint)
            np.save(Path + '/exec_time_Baron.npy', exec_time_Baron)
            
            
        
            
if __name__ == '__main__':
    
    input_file="ConfigFiles/system_file.json"

    main(input_file)
