//FosTRAP reactivation analysis Step 3
//Separates identfied cells and overlap into superficial and deep layers 
//Hwang, Roth, et al. 2022

Mouse = "3319" //MouseID
Ctx = "MCtx" //"MCtx" or "SSCtx"
Slice = "1" //"1" or "2"
ROInum = 0; //0 is first ROI, 1 is second ROI, ROI#0=R ROI#1=L


myPath = " "; //Set output path

//manually draw an ROI for superficial layers (Layer 2/3) before running this

if (ROInum == 0) {
	Hem = "R";
}
if (ROInum == 1) {
	Hem = "L";
}

ImgName = Mouse+"_"+Ctx+"_"+Slice+"_"+Hem;

myDir = myPath+ImgName;

roiManager("Save", myDir+"/L23.roi"); 

selectWindow("C1-Image.tif");
run("Select None");
run("Duplicate...", " ");
selectWindow("C1-Image-1.tif");
roiManager("Select", 0);
run("Clear Outside");
selectWindow("C1-Image.tif");
roiManager("Select", 0);
run("Clear", "slice");

selectWindow("C3-Image.tif");
run("Select None");
run("Duplicate...", " ");
selectWindow("C3-Image-1.tif");
roiManager("Select", 0);
run("Clear Outside");
selectWindow("C3-Image.tif");
roiManager("Select", 0);
run("Clear", "slice");

//L23
selectWindow("C1-Image-1.tif");
run("Select None");
run("Analyze Particles...", "size=20-Infinity circularity=0.20-1.00 display clear summarize add");
roiManager("Save", myDir+"/fosL23-RoiSet.zip");


selectWindow("C3-Image-1.tif");
run("Select None");
run("Analyze Particles...", "size=30-Infinity circularity=0.30-1.00 display clear summarize add");
roiManager("Save", myDir+"/TRAPL23-RoiSet.zip");

saveAs("Results", myDir+"/SummaryL23.csv");

selectWindow("C1-Image-1.tif");
roiManager("Show None");
roiManager("Show All");
roiManager("multi-measure measure_all");
saveAs("Results", myDir+"/Results_fos-in-TRAPROIsL23.csv");

selectWindow("C3-Image.tif");
roiManager("Open", myDir+"/fosL23-RoiSet.zip");
roiManager("Show None");
roiManager("Show All");
roiManager("multi-measure measure_all");
saveAs("Results", myDir+"/Results_TRAP-in-fosROIsL23.csv");

//L5
selectWindow("C1-Image.tif");
run("Select None");
run("Analyze Particles...", "size=20-Infinity circularity=0.20-1.00 display clear summarize add");
roiManager("Save", myDir+"/fosL5-RoiSet.zip");


selectWindow("C3-Image.tif");
run("Select None");
run("Analyze Particles...", "size=30-Infinity circularity=0.30-1.00 display clear summarize add");
roiManager("Save", myDir+"/TRAPL5-RoiSet.zip");

saveAs("Results", myDir+"/SummaryL5.csv");

selectWindow("C1-Image.tif");
roiManager("Show None");
roiManager("Show All");
roiManager("multi-measure measure_all");
saveAs("Results", myDir+"/Results_fos-in-TRAPROIsL5.csv");

selectWindow("C3-Image.tif");
roiManager("Open", myDir+"/fosL5-RoiSet.zip");
roiManager("Show None");
roiManager("Show All");
roiManager("multi-measure measure_all");
saveAs("Results", myDir+"/Results_TRAP-in-fosROIsL5.csv");

roiManager("Deselect");
roiManager("Delete");

selectWindow("C1-Image.tif");
close();
selectWindow("C2-Image.tif");
close();
selectWindow("C3-Image.tif");
close();
selectWindow("C1-Image-1.tif");
close();
selectWindow("C3-Image-1.tif");
close();

selectWindow("Results"); 
run("Close" );
selectWindow("SummaryL23.csv"); 
run("Close" );
selectWindow("SummaryL5.csv"); 
run("Close" );
selectWindow("Summary.csv"); 
run("Close" );

