//FosTRAP reactivation analysis Step 2
//Identifies cells in green and red channels and calculates cross-channel overlap
//Hwang, Roth, et al. 2022

Mouse = "3319" //MouseID
Ctx = "MCtx" //"MCtx" or "SSCtx"
Slice = "1" //"1" or "2"
ROInum = 0; //0 is first ROI, 1 is second ROI, ROI#0=R ROI#1=L

GreenThr = 22500; //Manually set threshold for green channel
RedThr = 15500; //Manually set threshold for red channel


myPath = " "; //Set output path

if (ROInum == 0) {
	Hem = "R";
}
if (ROInum == 1) {
	Hem = "L";
}

ImgName = Mouse+"_"+Ctx+"_"+Slice+"_"+Hem;

myDir = myPath+ImgName;
File.makeDirectory(myDir);
if (!File.exists(myDir))
exit("Unable to create directory");

//Safe image as "Image.tif" and split image into channels
      
saveAs("Tiff", myDir+"/Image.tif");
run("Select None");
run("Split Channels");

//Apply threshold set above as "GreenThr" for Ch1 and "RedThr" for Ch2

selectWindow("C1-Image.tif");
setThreshold(GreenThr, 65535);
run("Convert to Mask");

selectWindow("C3-Image.tif");
setThreshold(RedThr, 65535);
run("Convert to Mask");

//Run "despeckle" and "watershed to get rid of small speckles above threshold and separate adjoining cells

selectWindow("C1-Image.tif");
run("Despeckle");
run("Watershed");
selectWindow("C3-Image.tif");
run("Despeckle");
run("Watershed");

//Run "Analyze Particles" to label cells as ROIs in ROI manager

selectWindow("C1-Image.tif");
run("Analyze Particles...", "size=20-Infinity circularity=0.20-1.00 display clear summarize add");
roiManager("Save", myDir+"/fos-RoiSet.zip");
roiManager("XOR");
setBackgroundColor(0, 0, 0);
run("Clear Outside");

selectWindow("C3-Image.tif");
run("Analyze Particles...", "size=30-Infinity circularity=0.30-1.00 display clear summarize add");
roiManager("Save", myDir+"/TRAP-RoiSet.zip");
roiManager("XOR");
setBackgroundColor(0, 0, 0);
run("Clear Outside");

saveAs("Results", myDir+"/Summary.csv");

selectWindow("C1-Image.tif");
roiManager("Show None");
roiManager("Show All");
roiManager("multi-measure measure_all");
saveAs("Results", myDir+"/Results_fos-in-TRAPROIs.csv");

roiManager("Deselect");
roiManager("Delete");

selectWindow("C3-Image.tif");
roiManager("Open", myDir+"/fos-RoiSet.zip");
roiManager("Show None");
roiManager("Show All");
roiManager("multi-measure measure_all");
saveAs("Results", myDir+"/Results_TRAP-in-fosROIs.csv");

roiManager("Deselect");
roiManager("Delete");

selectWindow("C2-Image.tif");
run("Enhance Contrast", "saturated=0.35");