%%Hwang, Roth, et al. 2022
% MATLAB code for nearest neighbor distribution cdf
%% Nearst Neighbor distance distribution 
clear
close all
fileFolder = uigetdir('Select a folder');   %include all dendrites in that folder
dirOutput = dir(fullfile(fileFolder,'*_spine.mat'));   
cd(fileFolder);
name = {dirOutput.name};
k=1000;
for i = 1:size(dirOutput,1) 
    load (name{i});
    ActiveSpineAll{i} = Active_Spine;   % list of all 10 dendrites under that file (Both S1 AND M1)
    % Compute pairwise distance for active spine
    PW_Dist = pdist(ActiveSpineAll{i})';%pairwise distance 
    
    % Nearest Neighbor Distance
    NNd = NearestNeighborDistance(max(All_Spine),Active_Spine);  
    
    if i == 1   % build first list
    PW_Dist_Total_Active = PW_Dist; % ex: 27 spines=> 1 by 351 array) 
    NNd_Dist_Total_Active = NNd;    % ex: 27 spines=> 1 by 27 array)
    else        % conti adding
    PW_Dist_Total_Active(end+1:end+max(size(PW_Dist))) = PW_Dist;
    NNd_Dist_Total_Active(end+1:end+max(size(NNd))) = NNd;
    end
    clear Active_Spine
end
%% randomly sample from all spines to creat random_Spines
for n = 1 :k  %set 1000

    for i = 1:size(dirOutput,1)  
    load (name{i});
    ActiveSpineAll{i} = Active_Spine;
    SS = size(Active_Spine(:),1);    % number of ActiveSpines
    Random_Spine = datasample(All_Spine,SS,1);  %Randomly get n spines from All_Spines
    PW_Dist_Random = pdist(Random_Spine)';    % Get PairWised distance
    NNd_Random = abs(NearestNeighborDistance(max(All_Spine),sort(Random_Spine))); % =>1 by 27 array
        if i == 1
            PW_Dist_Total_Random = PW_Dist_Random;
            NNd_Dist_Total_Random = NNd_Random;
        else   % adding
            PW_Dist_Total_Random(end+1:end+max(size(PW_Dist_Random))) = PW_Dist_Random;  
%             
            NNd_Dist_Total_Random(end+1:end+max(size(NNd_Random))) = NNd_Random;
%             Combined_NNd_Dist_Total_Random(:,n) = NNd_Dist_Total_Random;
        end
  
    end
        Combined_PW_Dist_Total_Random(:,n) = PW_Dist_Total_Random;
        Combined_NNd_Dist_Total_Random(:,n) = NNd_Dist_Total_Random;
        clear Random_Spine
end

%% This part is to create NND_cdf (for Active_spines) and random_spines
c = 2000;       
NND_Result_Active = ones([c 1],'double'); % First creat a trace with 300 datapoints 
% creat cdf using PW_Dist_active
HistcountTemp = histcounts(NNd_Dist_Total_Active,'BinWidth',0.1,'Normalization','cdf');
NND_Result_Active(1:size(HistcountTemp(:))) = HistcountTemp;
NND_Result_Random = ones([c k],'double');  % First create a 300 by 1000 array
for i = 1:1000
HistcountTemp = histcounts(Combined_NNd_Dist_Total_Random(:,i),'BinWidth',0.1,'Normalization','cdf');
NND_Result_Random(1:size(HistcountTemp(:)),i) = HistcountTemp;
end
NND_Mean_Random = mean(NND_Result_Random,2); 
NND_STD_Random = std(NND_Result_Random,0,2);
NND_MeanPlusSTD = NND_Mean_Random + NND_STD_Random*1.96;  %95% confidence intervel
NND_MeanMinusSTD = NND_Mean_Random - NND_STD_Random*1.96;
NND_Subtracked_Active = NND_Result_Active - NND_Mean_Random; % Got the "difference"


%% plot results
figure1 = figure;
axes1 = axes('Parent',figure1);
hold(axes1,'on');
% for i = 1:100
%     H = plot(1:c,Result_Random(:,i));
%     set(H,'Color',[0.5 0.5 0.5]);
%     hold on
% end
plot1 = plot(1:c,NND_Result_Active, 1:c,NND_Mean_Random,1:c,NND_MeanMinusSTD,1:c,NND_MeanPlusSTD, 1:c,NND_Subtracked_Active,'LineWidth',2,'Parent',axes1);
set(plot1(1),'Color',[1 0 0]);
set(plot1(2),'Color',[0 0 0]);
set(plot1(3),'LineStyle',':',...
    'Color',[0.501960813999176 0.501960813999176 0.501960813999176]);
set(plot1(4),'LineStyle',':',...
    'Color',[0.501960813999176 0.501960813999176 0.501960813999176]);
set(plot1(5),'Color',[1 0.600000023841858 0.7843137383461]);
xlim(axes1,[0 50]);
ylim(axes1,[0 1.2]);
xlabel('nn distance (um)')
ylabel('Cumulative probability')
%% Save files 
T = table(X,NND_Result_Active,NND_Mean_Random,NND_STD_Random,NND_MeanPlusSTD,NND_MeanMinusSTD )
writetable(T, 'NND_Stats.csv')
save('NND_Stats.mat','X','NND_Result_Active','NND_Mean_Random','NND_STD_Random','NND_MeanPlusSTD','NND_MeanMinusSTD');