%%Hwang, Roth, et al. 2022
% MATLAB Code for Nearest Neighbor distance / index analysis 
clear 
A = []    %need to key in ALL spine location
B = []    %need to key in Active Spine location

%%
All_Spine = sort(A); % sort the distance in order
Active_Spine = sort(B);

%% probability density function is based on this data (for interpolation)
edges = [0:5:250]; % Define the rage of analysis (um)...bin to 50 section
All_Spine_PDF = histcounts(All_Spine,edges);  %hist
Active_Spine_PDF = histcounts(Active_Spine,edges);  %hist
% do spline interpolation for smoothing 
xq = 0 : 1 : max(edges);
pdf = interp1(edges(1:end-1), All_Spine_PDF, xq, 'linear','extrap'); %'spline');
plot(edges(1:end-1),All_Spine_PDF',xq',pdf');    %pdf or I called it hist_Pr

% remove negative elements due to the spline interpolation
pdf(pdf < 0) = 0;
% normalize the function to have an area of 1.0 under it
pdf = pdf / sum(pdf);

% the integral of PDF is the cumulative distribution function (cdf)
cdf = cumsum(pdf);
% these two variables holds and describes the CDF
xq;         % x
cdf;        % P(x) Cumulative function

% remove non-unique elements
[cdf, mask] = unique(cdf);
xq = xq(mask);

%% create an array of 1000 random numbers 
for n = 1:1000
randomValues = rand(1, max(size(Active_Spine(:)))); % random number default between 0~1 (ex:1 by 27 array)
%inverse interpolation to achieve P(x) -> x projection of the random values
Control_Spine_Distribution(:,n) = interp1(cdf, xq, randomValues,'linear','extrap');
Rand(:,n) = randomValues;  %gengerate 1000 types of "active ones ex: 27 by 1000 array"
%hist(projection, 50);
end

%% Nearest Neighbor Test for Activee Spine
[NN_obsA NN_ranA NNIA Std_NNA SE_NNA pA tscoreA] = AverageNearestNeighborIndex(max(All_Spine),Active_Spine);

% Nearest Neighbor Test for Random Generated Spine Distribution
for n = 1:1000 % random 1000 patterns
[NN_obs NN_ran NNI Std_NN SE_NN p tscore] = AverageNearestNeighborIndex(max(All_Spine),sort(Control_Spine_Distribution(:,n)));

% Collect results for 1000 patterns
NN_obsC(n)= NN_obs;
NN_ranC(n)=NN_ran;
NNIC(n)=NNI;  
Std_NNC(n)= Std_NN;
SE_NNC(n)= SE_NN;
pC(n) = p;
tscoreC(n)=tscore;
end

% get mean result from 1000 repeats
NN_obs_Ctrl = mean(NN_obsC);
NN_ranC_Ctrl= mean(NN_ranC);
NNI_Ctrl= mean(NNIC);  
Std_NN_Ctrl= mean(Std_NNC);
SE_NN_Ctrl= mean(SE_NNC);
p_Ctrl = mean(pC);
tscore_Ctrl= mean(tscoreC);

% Compare Observed vs Control (the only result we need)
NNI_AvsC = NN_obsA/NN_obs_Ctrl
tscore_AvsC = (NN_obsA - NN_obs_Ctrl)/SE_NNA
p_AvsC = 2*tcdf(-abs(tscore_AvsC),size(Active_Spine,1)-1)
ActiveSpineDensity = max(size(Active_Spine(:)))/All_Spine(end);
AllSpineDensity = max(size(All_Spine(:)))/All_Spine(end);
Result = [AllSpineDensity max(size(Active_Spine(:))) ActiveSpineDensity 1 NNI_AvsC tscore_AvsC p_AvsC]


%% Save files
save('2021xxxx_spine.mat','Active_Spine','All_Spine','Result');


%% need to have Dist = pdist(ActiveSpineAll{1}); 
    if i == 1
        PairDist = Dist;   
        NNdDist = NNd;
        NNdDist_Random = NNd_Random(:);
    else
        PairDist(end:end+max(size(Dist))-1)=Dist;  
        NNdDist(end:end+max(size(NNd))-1)=NNd;
        NNdDist_Random(end:end+max(size(NNd)*k)-1)= NNd_Random;
    end
    clear Random_Spine NNd_Random

Control_PDF = zeros([50 k],'double');
for n = 1:k
    for i = size(dirOutput,1)
        
                    if i == 1
                NNdDist_Random = NNd_Random(:);
            else
                NNdDist_Random(end:end+max(size(NNd))-1)= NNd_Random;
            end
    clear Random_Spine NNd_Random
    end
    N = histcounts(NNdDist_Random,'BinWidth',2,'Normalization','pdf');
    
end
% histogram(PairDist,'BinWidth',1,'Normalization','pdf');
% hold;
histogram(NNdDist,'BinWidth',2,'Normalization','pdf');
hold;
histogram(NNdDist_Random,'BinWidth',2,'Normalization','pdf');

figure;
histogram(PairDist,'BinWidth',2,'Normalization','pdf');
hold;
histogram(PairDist_Random,'BinWidth',2,'Normalization','pdf');
%%


%%
Dist = pdist(ActiveSpineAll{1});
%%
for i = 1:1000
Dist_Ctrl(:,i) = pdist(Control_Spine_Distribution(:,i));
end
histogram(Dist_Ctrl(:));
hold
histogram(Dist);


%%
fileID = fopen('Active.txt','w');
fprintf(fileID,'%s\n','AS');
fprintf(fileID,'%6.4f\n',Active_Spine);
fclose(fileID);



