function [NN_obs NN_ran NNI Std_NN SE_NN p tscore] = AverageNearestNeighborIndex(L,X)


% X = d1A; ALL_Spine
last = size(X,1);    %number of spines
% L = max(d1); the farest spine distance
NNd = zeros(size(X),'double'); %actually just creat a array with the same size
NNd(1,1) = X(2)- X(1);  
NNd(last,1) = X(last)- X(last-1);   %Calculate First and last (only with one neighbor (need to deal with first)
for k=2:last-1  %from 2 to last-1,
    d(1) = X(k) - X(k-1);
    d(2) = X(k+1) - X(k);
    NNd(k,1) = min(d(:));  % Get the nearest (mini)  
end                      

NN_obs = mean(NNd);  % avg the nn distance Observed
NN_ran = L/(last-1); % Ran (whole lenghth / number of gaps)
NNI = NN_obs/NN_ran; % Index is the "ratio" (0.52<1)
Std_NN = std(NNd,0,1);
SE_NN = Std_NN/last^0.5;
tscore = (NN_obs-NN_ran)/SE_NN;  % Diff b/w groups / Diff within individuals  
p = 2*tcdf(-abs(tscore),last-1);  % p_value



