<!---
This file was generated from `meta.yml`, please do not edit manually.
Follow the instructions on https://gitlab.com/ana-borges/templates to regenerate.
--->
# Coq formalization of QRC<sub>1</sub>

[![GitLab CI][pipeline-shield]][pipeline-link]
[![coqdoc][coqdoc-shield]][coqdoc-link]

[pipeline-shield]: https://img.shields.io/gitlab/pipeline/ana-borges/QRC1-Coq/master
[pipeline-link]: https://gitlab.com/ana-borges/QRC1-Coq/-/pipelines


[coqdoc-shield]: https://img.shields.io/badge/docs-coqdoc-blue.svg
[coqdoc-link]: https://ana-borges.gitlab.io/QRC1-Coq/toc.html


This library defines the language, calculus and Kripke semantics of
QRC<sub>1</sub>. There is a proof of Kripke soundness and an ongoing proof of
completeness.

## Meta

- Author(s):
  - Ana de Almeida Borges (initial)
- License: [Mozilla Public License 2.0](LICENSE)
- Compatible Coq versions: 8.12 to 8.15
- Additional dependencies:
  - [MathComp](https://math-comp.github.io) 1.13.0 (`ssreflect` suffices)
  - [Finmap](https://github.com/math-comp/finmap) 1.5.1
- Coq namespace: `QRC1`
- Related publication(s):
  - [Quantified Reflection Calculus with one modality](https://arxiv.org/pdf/2003.13651.pdf) 
  - [An Escape from Vardanyan's Theorem](https://arxiv.org/pdf/2102.13091.pdf) 

## Building and installation instructions

Start by making sure the dependencies are installed. Then:
``` shell
git clone https://gitlab.com/ana-borges/QRC1-Coq.git
cd QRC1-Coq
make   # or make -j <number-of-cores-on-your-machine>
```

## Project summary

A summary of the project linking it to the relevant references is available
in `theories/Summary.v` and can be inspected
[online](https://ana-borges.gitlab.io/QRC1-Coq/Summary.html).

## HTML Documentation

To generate HTML documentation, run `make coqdoc` and point your browser at
`docs/coqdoc/toc.html`.

The documentation is also available
[online](https://ana-borges.gitlab.io/QRC1-Coq/toc.html).
 
The documentation is generated with
[CoqdocJS](https://github.com/palmskog/coqdocjs).

## File Contents

- `Preamble.v`: facts unrelated to QRC<sub>1</sub>
- `Language.v`: the language of QRC<sub>1</sub>
- `QRC1.v`: the calculus QRC<sub>1</sub> and basic consequences
- `QRC1Equiv.v`: the notion of QRC<sub>1</sub> equivalence
- `KripkeSemantics.v`: the notions of frame and model and the soundness proof
- `Closure.v`: the notion of closure and related results
- `Pairs.v`: the notion of pair and ongoing completeness proof
- `Summary.v`: a summary of the main definitions and results
