/**
 * @name replaceAllRows
 * @description updating all 1,000 rows
 */
// @ts-nocheck

import * as hundred from 'hundred';
import { createElement } from 'src/million';
import * as simple_virtual_dom from 'simple-virtual-dom';
import * as snabbdom from 'snabbdom';
import * as virtual_dom from 'virtual-dom';
import {
  hundredAdapter,
  simpleVirtualDomAdapter,
  snabbdomAdapter,
  Suite,
  virtualDomAdapter,
} from '../benchmark';
import { buildData, patch } from '../data';

const shuffleArray = (array: unknown[]) => {
  for (
    let i = array.length - 1 - Math.floor(Math.random() * (data.length / 3 + 1));
    i > Math.floor(Math.random() * (data.length / 3 + 1));
    i--
  ) {
    const j = Math.floor(Math.random() * (i + 1));
    [array[i], array[j]] = [array[j], array[i]];
  }
};

const data = buildData(1000);
const createVNode = () => (
  <table>
    {data.map(({ id, label }) => (
      <tr key={String(id)}>
        <td>{id}</td>
        <td>{label}</td>
      </tr>
    ))}
  </table>
);
const oldVNode = createVNode();
const el = () => createElement(oldVNode);

shuffleArray(data);

const vnode = createVNode();

const suite = Suite('replace all rows (updating all 1,000 rows)', {
  million: () => {
    patch(el(), vnode);
  },
  hundred: () => {
    hundred.patch(el(), hundredAdapter(vnode), hundredAdapter(oldVNode));
  },
  'simple-virtual-dom': () => {
    const patches = simple_virtual_dom.diff(
      simpleVirtualDomAdapter(oldVNode),
      simpleVirtualDomAdapter(vnode),
    );
    simple_virtual_dom.patch(el(), patches);
  },
  'virtual-dom': () => {
    const patches = virtual_dom.diff(virtualDomAdapter(oldVNode), virtualDomAdapter(vnode));
    virtual_dom.patch(el(), patches);
  },
  snabbdom: () => {
    const patch = snabbdom.init([]);
    patch(snabbdom.toVNode(el()), snabbdomAdapter(vnode));
  },
  DOM: () => {
    el().childNodes.forEach((tr, i) => {
      const { id, label } = data[i];
      tr.childNodes.item(0).textContent = String(id);
      tr.childNodes.item(1).textContent = label;
    });
  },
  innerHTML: () => {
    const element = el();
    let html = '';
    data.forEach(({ id, label }) => {
      html += `<tr><td>${String(id)}</td><td>${label}</td></tr>`;
    });
    element.innerHTML = html;
  },
});

export default suite;
