library("ggplot2")
library(dplyr)
library(gridExtra)
library(ggpubr)

stats = read.delim2("combined_THID_results.tsv")
pdf("combined_THID_ranks.pdf")

## colorbind palette from http://www.cookbook-r.com/Graphs/Colors_(ggplot2)/
cbbPalette <- c("#000000", "#E69F00", "#56B4E9", "#009E73", "#F0E442", "#0072B2", "#D55E00", "#CC79A7")
db.colors <- c(taxalogue = "#000000", midori = "#E69F00", porter = "#56B4E9", tidybug = "#009E73")

stats.100 = stats[stats$identity == 100, ]

stats.100.with_ranks = stats.100 %>%
  group_by(sample) %>%
  mutate(rank = dense_rank(hits))

# print.data.frame(stats.100.with_ranks)

dbs = c("taxalogue", "midori", "tidybug", "porter")
ggplot(data=stats.100.with_ranks, aes(x=db, y=rank, fill=factor(db, levels=dbs))) +
    geom_violin() +
    geom_boxplot(width = 0.1, color="#707070") +
    theme_classic() +
    scale_fill_manual(values=db.colors) + 
    labs(x = "reference database", title = "", fill = "reference database")