library("ggplot2")
library(dplyr)
library(gridExtra)
library(ggpubr)
library(ggstance)

stats = read.delim2("combined_THID_results.tsv")
pdf("combined_THID_results.pdf", onefile=FALSE)

## colorbind palette from http://www.cookbook-r.com/Graphs/Colors_(ggplot2)/
cbbPalette <- c("#000000", "#E69F00", "#56B4E9", "#009E73", "#F0E442", "#0072B2", "#D55E00", "#CC79A7")

db.colors <- c(taxalogue = "#000000", midori = "#E69F00", porter = "#56B4E9", tidybug = "#009E73")
db.shapes <- c(taxalogue = 1, midori = 2, porter = 3, tidybug = 4)

stats.honduras = stats[stats$sample == "honduras", ]
stats.canada_benthos = stats[stats$sample == "canada_benthos", ]
stats.costa_rica_malaise = stats[stats$sample == "costa_rica_malaise", ]
stats.germany_malaise_RAW = stats[stats$sample == "germany_malaise_RAW", ]
stats.china_malaise = stats[stats$sample == "china_malaise", ]
stats.portugal_light_trap = stats[stats$sample == "portugal_light_trap", ]
stats.canada_malaise = stats[stats$sample == "canada_malaise", ]
stats.china_malaise2 = stats[stats$sample == "china_malaise2", ]

dbs = c("taxalogue", "midori", "tidybug", "porter")


p1 = ggplot(stats.germany_malaise_RAW, aes(x=identity, y=hits, color=db)) + geom_step() + geom_point(cex=0.4, aes(shape=db)) + scale_x_reverse() + theme_classic() + scale_color_manual(values=db.colors) + labs(title = "Germany: Malaise trap", tag = 'A', color = "reference database", shape = "reference database") + theme(plot.title = element_text(size = 10, hjust = 0.5)) + scale_shape_manual(values=db.shapes, guide="none") + guides(colour = guide_legend(override.aes = list(shape = db.shapes)))
p2 = ggplot(stats.costa_rica_malaise, aes(x=identity, y=hits, color=db)) + geom_step() + geom_point(cex=0.4, aes(shape=db)) + scale_x_reverse() + theme_classic() + scale_color_manual(values=db.colors)+ labs(title = "Costa Rica: Malaise trap", tag = 'B') + theme(plot.title = element_text(size = 10, hjust = 0.5)) + scale_shape_manual(values=db.shapes)
p3 = ggplot(stats.canada_benthos, aes(x=identity, y=hits, color=db)) + geom_step() + geom_point(cex=0.4, aes(shape=db)) + scale_x_reverse() + theme_classic() + scale_color_manual(values=db.colors)+ labs(title = "Canada: Kick net", tag = 'C') + theme(plot.title = element_text(size = 10, hjust = 0.5)) + scale_shape_manual(values=db.shapes)
p4 = ggplot(stats.honduras, aes(x=identity, y=hits, color=db)) + geom_step() + geom_point(cex=0.4, aes(shape=db)) + scale_x_reverse() + theme_classic() + scale_color_manual(values=db.colors)+ labs(title = "Honduras: Canopy fogging", tag = 'D') + theme(plot.title = element_text(size = 10, hjust = 0.5)) + scale_shape_manual(values=db.shapes)
p5 = ggplot(stats.china_malaise, aes(x=identity, y=hits, color=db)) + geom_step() + geom_point(cex=0.4, aes(shape=db)) + scale_x_reverse() + theme_classic() + scale_color_manual(values=db.colors)+ labs(title = "China: Malaise trap", tag = 'E') + theme(plot.title = element_text(size = 10, hjust = 0.5)) + scale_shape_manual(values=db.shapes)
p6 = ggplot(stats.portugal_light_trap, aes(x=identity, y=hits, color=db)) + geom_step() + geom_point(cex=0.4, aes(shape=db)) + scale_x_reverse() + theme_classic() + scale_color_manual(values=db.colors)+ labs(title = "Portugal: Light trap", tag = 'F') + theme(plot.title = element_text(size = 10, hjust = 0.5)) + scale_shape_manual(values=db.shapes)
p7 = ggplot(stats.canada_malaise, aes(x=identity, y=hits, color=db)) + geom_step() + geom_point(cex=0.4, aes(shape=db)) + scale_x_reverse() + theme_classic() + scale_color_manual(values=db.colors)+ labs(title = "Canada: Malaise trap", tag = 'G') + theme(plot.title = element_text(size = 10, hjust = 0.5)) + scale_shape_manual(values=db.shapes)
p8 = ggplot(stats.china_malaise2, aes(x=identity, y=hits, color=db)) + geom_step() + geom_point(cex=0.4, aes(shape=db)) + scale_x_reverse() + theme_classic() + scale_color_manual(values=db.colors)+ labs(title = "China: Malaise trap [2]", tag = 'H') + theme(plot.title = element_text(size = 10, hjust = 0.5)) + scale_shape_manual(values=db.shapes)

ggarrange(p1, p2, p3, p4, p5, p6, p7, p8, ncol=2, nrow=4, common.legend = TRUE, legend="bottom")
