#!/bin/bash
#loop over a list of species, and obtain the corresponding mitogenome accession ID - this ID is then used in the download step
cat target_species.txt | while read line
do
	target_species=$line
	grep $target_species nuclear_genome_stats_Dec2021.csv | cut -d ',' -f 11 > $target_species.mitogenome_accession.txt
	gsed -i 's/\r$//' $target_species.mitogenome_accession.txt
	cat $target_species.mitogenome_accession.txt | while read line
	do
	accession=$line
	#this downloads the standard fasta and gbk format 	
	ncbi-acc-download $accession --format fasta
	ncbi-acc-download $accession
	mv $accession.fa mitogenomes/$target_species.mitogenome.fa
	mv $accession.gbk mitogenomes/$target_species.mitogenome.gbk
	done
rm $target_species.mitogenome_accession.txt
done


